@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The status for an operation or group of operations.
 * @property completedTime The time the operation or group was completed.
 * @property error The error details when a failure is encountered.
 * @property startTime The time the operation or group was started.
 * @property state The State of the operation or group.
 */
public data class UpdateStatusResponse(
    public val completedTime: String,
    public val error: ErrorDetailResponse,
    public val startTime: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.UpdateStatusResponse):
            UpdateStatusResponse = UpdateStatusResponse(
            completedTime = javaType.completedTime(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
            }),
            startTime = javaType.startTime(),
            state = javaType.state(),
        )
    }
}
