@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin

import com.pulumi.azurenative.containerstorage.VolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-07-01-preview. Prior API version in Azure Native 1.x: 2023-03-01-preview.
 * ## Example Usage
 * ### Volumes_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.ContainerStorage.Volume("volume", new()
 *     {
 *         CapacityGiB = 25838,
 *         Labels =
 *         {
 *             { "key2039", "value2039" },
 *         },
 *         PoolName = "test-pool",
 *         ResourceGroupName = "test-rg",
 *         VolumeName = "test-volume",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerstorage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerstorage.NewVolume(ctx, "volume", &containerstorage.VolumeArgs{
 * 			CapacityGiB: pulumi.Float64(25838),
 * 			Labels: pulumi.StringMap{
 * 				"key2039": pulumi.String("value2039"),
 * 			},
 * 			PoolName:          pulumi.String("test-pool"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			VolumeName:        pulumi.String("test-volume"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerstorage.Volume;
 * import com.pulumi.azurenative.containerstorage.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .capacityGiB(25838)
 *             .labels(Map.of("key2039", "value2039"))
 *             .poolName("test-pool")
 *             .resourceGroupName("test-rg")
 *             .volumeName("test-volume")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerstorage:Volume test-volume /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerStorage/pools/{poolName}/volumes/{volumeName}
 * ```
 * @property capacityGiB Requested capacity in GiB
 * @property labels String KV pairs indicating labels
 * @property poolName Pool Object
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeName Volume Resource
 */
public data class VolumeArgs(
    public val capacityGiB: Output<Double>? = null,
    public val labels: Output<Map<String, String>>? = null,
    public val poolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val volumeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.VolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.VolumeArgs =
        com.pulumi.azurenative.containerstorage.VolumeArgs.builder()
            .capacityGiB(capacityGiB?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var capacityGiB: Output<Double>? = null

    private var labels: Output<Map<String, String>>? = null

    private var poolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value Requested capacity in GiB
     */
    @JvmName("gmxauocqdglieniu")
    public suspend fun capacityGiB(`value`: Output<Double>) {
        this.capacityGiB = value
    }

    /**
     * @param value String KV pairs indicating labels
     */
    @JvmName("punvlrtpecwwxbni")
    public suspend fun labels(`value`: Output<Map<String, String>>) {
        this.labels = value
    }

    /**
     * @param value Pool Object
     */
    @JvmName("ljeqtynxrcxwgnyw")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sbrckbeexbdnihwi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Volume Resource
     */
    @JvmName("ewtpewpfdbhgunoh")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value Requested capacity in GiB
     */
    @JvmName("ugwiyruvpkxpasrk")
    public suspend fun capacityGiB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityGiB = mapped
    }

    /**
     * @param value String KV pairs indicating labels
     */
    @JvmName("umkffndmuxsvdheq")
    public suspend fun labels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values String KV pairs indicating labels
     */
    @JvmName("daecyaiimufiimcj")
    public fun labels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Pool Object
     */
    @JvmName("dtcweotjosutsfbb")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fxtxbfdikooamour")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Volume Resource
     */
    @JvmName("ywgfmqtoxcxcjnku")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        capacityGiB = capacityGiB,
        labels = labels,
        poolName = poolName,
        resourceGroupName = resourceGroupName,
        volumeName = volumeName,
    )
}
