@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Availability Zones
 */
public enum class Zone(
    public val javaValue: com.pulumi.azurenative.containerstorage.enums.Zone,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.enums.Zone> {
    /**
     * First availability zone.
     */
    Zone1(com.pulumi.azurenative.containerstorage.enums.Zone.Zone1),

    /**
     * Second availability zone.
     */
    Zone2(com.pulumi.azurenative.containerstorage.enums.Zone.Zone2),

    /**
     * Third availability zone.
     */
    Zone3(com.pulumi.azurenative.containerstorage.enums.Zone.Zone3),
    ;

    override fun toJava(): com.pulumi.azurenative.containerstorage.enums.Zone = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.enums.Zone): Zone =
            Zone.values().first { it.javaValue == javaType }
    }
}
