@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.AssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Assignment Properties
 * @property id Resource id for the assigned resource
 */
public data class AssignmentArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.AssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.AssignmentArgs =
        com.pulumi.azurenative.containerstorage.inputs.AssignmentArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssignmentArgs].
 */
@PulumiTagMarker
public class AssignmentArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource id for the assigned resource
     */
    @JvmName("gfotswnwugqpdqhl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource id for the assigned resource
     */
    @JvmName("otemxysflfgwapnw")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): AssignmentArgs = AssignmentArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
