@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.DiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model for disk for that pool is using
 * @property id ID is the disk identifier visible to the OS. It is typically the WWN or disk ID in formats such as eui.e8238fa6bf530001001b448b45263379 or 0x5002cf6cbc5dd460
 * @property reference Reference is the location of the disk in an external system.
 */
public data class DiskArgs(
    public val id: Output<String>,
    public val reference: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.DiskArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.DiskArgs =
        com.pulumi.azurenative.containerstorage.inputs.DiskArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .reference(reference.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskArgs].
 */
@PulumiTagMarker
public class DiskArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var reference: Output<String>? = null

    /**
     * @param value ID is the disk identifier visible to the OS. It is typically the WWN or disk ID in formats such as eui.e8238fa6bf530001001b448b45263379 or 0x5002cf6cbc5dd460
     */
    @JvmName("dupwkvehjeaetkck")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Reference is the location of the disk in an external system.
     */
    @JvmName("jhdwnbrxjxtobcuq")
    public suspend fun reference(`value`: Output<String>) {
        this.reference = value
    }

    /**
     * @param value ID is the disk identifier visible to the OS. It is typically the WWN or disk ID in formats such as eui.e8238fa6bf530001001b448b45263379 or 0x5002cf6cbc5dd460
     */
    @JvmName("wfrspvhcltdhefrj")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Reference is the location of the disk in an external system.
     */
    @JvmName("mptbehewlnjhtnve")
    public suspend fun reference(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reference = mapped
    }

    internal fun build(): DiskArgs = DiskArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        reference = reference ?: throw PulumiNullFieldException("reference"),
    )
}
