@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.ElasticSanArgs.builder
import com.pulumi.azurenative.containerstorage.kotlin.enums.ElasticSanSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Elastic San Pool Properties
 * @property encryption Encryption specifies the encryption configuration for the Azure Disk pool
 * @property skuName Sku name
 */
public data class ElasticSanArgs(
    public val encryption: Output<EncryptionArgs>? = null,
    public val skuName: Output<Either<String, ElasticSanSkuName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.ElasticSanArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.ElasticSanArgs =
        com.pulumi.azurenative.containerstorage.inputs.ElasticSanArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .skuName(
                skuName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ElasticSanArgs].
 */
@PulumiTagMarker
public class ElasticSanArgsBuilder internal constructor() {
    private var encryption: Output<EncryptionArgs>? = null

    private var skuName: Output<Either<String, ElasticSanSkuName>>? = null

    /**
     * @param value Encryption specifies the encryption configuration for the Azure Disk pool
     */
    @JvmName("aelgubxdyxuqyhow")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Sku name
     */
    @JvmName("jdfdcppaawbngoqh")
    public suspend fun skuName(`value`: Output<Either<String, ElasticSanSkuName>>) {
        this.skuName = value
    }

    /**
     * @param value Encryption specifies the encryption configuration for the Azure Disk pool
     */
    @JvmName("cocookapdviqcwfe")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption specifies the encryption configuration for the Azure Disk pool
     */
    @JvmName("hxbqemfpkmcbijuh")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Sku name
     */
    @JvmName("sfuakdvfsfxilhia")
    public suspend fun skuName(`value`: Either<String, ElasticSanSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    /**
     * @param value Sku name
     */
    @JvmName("qhsbpvihvpfdmrtn")
    public fun skuName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ElasticSanSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    /**
     * @param value Sku name
     */
    @JvmName("arwermnvleighhnc")
    public fun skuName(`value`: ElasticSanSkuName) {
        val toBeMapped = Either.ofRight<String, ElasticSanSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    internal fun build(): ElasticSanArgs = ElasticSanArgs(
        encryption = encryption,
        skuName = skuName,
    )
}
