@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.GetSnapshotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property poolName Pool Object
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property snapshotName Volume Snapshot Resource
 */
public data class GetSnapshotPlainArgs(
    public val poolName: String,
    public val resourceGroupName: String,
    public val snapshotName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.GetSnapshotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.GetSnapshotPlainArgs =
        com.pulumi.azurenative.containerstorage.inputs.GetSnapshotPlainArgs.builder()
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .snapshotName(snapshotName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSnapshotPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotPlainArgsBuilder internal constructor() {
    private var poolName: String? = null

    private var resourceGroupName: String? = null

    private var snapshotName: String? = null

    /**
     * @param value Pool Object
     */
    @JvmName("ukfmeevhhmvailwd")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jqrrgscltdintnjv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Volume Snapshot Resource
     */
    @JvmName("xgcadpdppyypvxck")
    public suspend fun snapshotName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.snapshotName = mapped
    }

    internal fun build(): GetSnapshotPlainArgs = GetSnapshotPlainArgs(
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        snapshotName = snapshotName ?: throw PulumiNullFieldException("snapshotName"),
    )
}
