@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.ResourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource Requests for the pool.
 * @property requests Requests for capacity for the pool.
 */
public data class ResourcesArgs(
    public val requests: Output<RequestsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.ResourcesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.ResourcesArgs =
        com.pulumi.azurenative.containerstorage.inputs.ResourcesArgs.builder()
            .requests(requests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourcesArgs].
 */
@PulumiTagMarker
public class ResourcesArgsBuilder internal constructor() {
    private var requests: Output<RequestsArgs>? = null

    /**
     * @param value Requests for capacity for the pool.
     */
    @JvmName("efllyqpxtsuoigfu")
    public suspend fun requests(`value`: Output<RequestsArgs>) {
        this.requests = value
    }

    /**
     * @param value Requests for capacity for the pool.
     */
    @JvmName("lacnuqwspeatpgym")
    public suspend fun requests(`value`: RequestsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument Requests for capacity for the pool.
     */
    @JvmName("atyndxwaxduleviw")
    public suspend fun requests(argument: suspend RequestsArgsBuilder.() -> Unit) {
        val toBeMapped = RequestsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    internal fun build(): ResourcesArgs = ResourcesArgs(
        requests = requests,
    )
}
