@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Status of the assignment resource
 * @property message Reason for the status
 * @property state State of the assignment resource
 */
public data class AssignmentStatusResponse(
    public val message: String? = null,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.AssignmentStatusResponse):
            AssignmentStatusResponse = AssignmentStatusResponse(
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
        )
    }
}
