@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.ExportArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.FormatType
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ExportDefinitionArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ExportDefinitionArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ExportDeliveryInfoArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ExportDeliveryInfoArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ExportScheduleArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ExportScheduleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An export resource.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2019-10-01, 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### ExportCreateOrUpdateByBillingAccount
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var export = new AzureNative.CostManagement.Export("export", new()
 *     {
 *         Definition = new AzureNative.CostManagement.Inputs.ExportDefinitionArgs
 *         {
 *             DataSet = new AzureNative.CostManagement.Inputs.ExportDatasetArgs
 *             {
 *                 Configuration = new AzureNative.CostManagement.Inputs.ExportDatasetConfigurationArgs
 *                 {
 *                     Columns = new[]
 *                     {
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity",
 *                     },
 *                 },
 *                 Granularity = "Daily",
 *             },
 *             Timeframe = "MonthToDate",
 *             Type = "ActualCost",
 *         },
 *         DeliveryInfo = new AzureNative.CostManagement.Inputs.ExportDeliveryInfoArgs
 *         {
 *             Destination = new AzureNative.CostManagement.Inputs.ExportDeliveryDestinationArgs
 *             {
 *                 Container = "exports",
 *                 ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182",
 *                 RootFolderPath = "ad-hoc",
 *             },
 *         },
 *         ExportName = "TestExport",
 *         Format = "Csv",
 *         Schedule = new AzureNative.CostManagement.Inputs.ExportScheduleArgs
 *         {
 *             Recurrence = "Weekly",
 *             RecurrencePeriod = new AzureNative.CostManagement.Inputs.ExportRecurrencePeriodArgs
 *             {
 *                 From = "2020-06-01T00:00:00Z",
 *                 To = "2020-10-31T00:00:00Z",
 *             },
 *             Status = "Active",
 *         },
 *         Scope = "providers/Microsoft.Billing/billingAccounts/123456",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := costmanagement.NewExport(ctx, "export", &costmanagement.ExportArgs{
 * Definition: costmanagement.ExportDefinitionResponse{
 * DataSet: interface{}{
 * Configuration: &costmanagement.ExportDatasetConfigurationArgs{
 * Columns: pulumi.StringArray{
 * pulumi.String("Date"),
 * pulumi.String("MeterId"),
 * pulumi.String("ResourceId"),
 * pulumi.String("ResourceLocation"),
 * pulumi.String("Quantity"),
 * },
 * },
 * Granularity: pulumi.String("Daily"),
 * },
 * Timeframe: pulumi.String("MonthToDate"),
 * Type: pulumi.String("ActualCost"),
 * },
 * DeliveryInfo: costmanagement.ExportDeliveryInfoResponse{
 * Destination: &costmanagement.ExportDeliveryDestinationArgs{
 * Container: pulumi.String("exports"),
 * ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 * RootFolderPath: pulumi.String("ad-hoc"),
 * },
 * },
 * ExportName: pulumi.String("TestExport"),
 * Format: pulumi.String("Csv"),
 * Schedule: costmanagement.ExportScheduleResponse{
 * Recurrence: pulumi.String("Weekly"),
 * RecurrencePeriod: &costmanagement.ExportRecurrencePeriodArgs{
 * From: pulumi.String("2020-06-01T00:00:00Z"),
 * To: pulumi.String("2020-10-31T00:00:00Z"),
 * },
 * Status: pulumi.String("Active"),
 * },
 * Scope: pulumi.String("providers/Microsoft.Billing/billingAccounts/123456"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Export;
 * import com.pulumi.azurenative.costmanagement.ExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var export = new Export("export", ExportArgs.builder()
 *             .definition(Map.ofEntries(
 *                 Map.entry("dataSet", Map.ofEntries(
 *                     Map.entry("configuration", Map.of("columns",
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity")),
 *                     Map.entry("granularity", "Daily")
 *                 )),
 *                 Map.entry("timeframe", "MonthToDate"),
 *                 Map.entry("type", "ActualCost")
 *             ))
 *             .deliveryInfo(Map.of("destination", Map.ofEntries(
 *                 Map.entry("container", "exports"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 *                 Map.entry("rootFolderPath", "ad-hoc")
 *             )))
 *             .exportName("TestExport")
 *             .format("Csv")
 *             .schedule(Map.ofEntries(
 *                 Map.entry("recurrence", "Weekly"),
 *                 Map.entry("recurrencePeriod", Map.ofEntries(
 *                     Map.entry("from", "2020-06-01T00:00:00Z"),
 *                     Map.entry("to", "2020-10-31T00:00:00Z")
 *                 )),
 *                 Map.entry("status", "Active")
 *             ))
 *             .scope("providers/Microsoft.Billing/billingAccounts/123456")
 *             .build());
 *     }
 * }
 * ```
 * ### ExportCreateOrUpdateByDepartment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var export = new AzureNative.CostManagement.Export("export", new()
 *     {
 *         Definition = new AzureNative.CostManagement.Inputs.ExportDefinitionArgs
 *         {
 *             DataSet = new AzureNative.CostManagement.Inputs.ExportDatasetArgs
 *             {
 *                 Configuration = new AzureNative.CostManagement.Inputs.ExportDatasetConfigurationArgs
 *                 {
 *                     Columns = new[]
 *                     {
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity",
 *                     },
 *                 },
 *                 Granularity = "Daily",
 *             },
 *             Timeframe = "MonthToDate",
 *             Type = "ActualCost",
 *         },
 *         DeliveryInfo = new AzureNative.CostManagement.Inputs.ExportDeliveryInfoArgs
 *         {
 *             Destination = new AzureNative.CostManagement.Inputs.ExportDeliveryDestinationArgs
 *             {
 *                 Container = "exports",
 *                 ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182",
 *                 RootFolderPath = "ad-hoc",
 *             },
 *         },
 *         ExportName = "TestExport",
 *         Format = "Csv",
 *         Schedule = new AzureNative.CostManagement.Inputs.ExportScheduleArgs
 *         {
 *             Recurrence = "Weekly",
 *             RecurrencePeriod = new AzureNative.CostManagement.Inputs.ExportRecurrencePeriodArgs
 *             {
 *                 From = "2020-06-01T00:00:00Z",
 *                 To = "2020-10-31T00:00:00Z",
 *             },
 *             Status = "Active",
 *         },
 *         Scope = "providers/Microsoft.Billing/billingAccounts/12/departments/1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := costmanagement.NewExport(ctx, "export", &costmanagement.ExportArgs{
 * Definition: costmanagement.ExportDefinitionResponse{
 * DataSet: interface{}{
 * Configuration: &costmanagement.ExportDatasetConfigurationArgs{
 * Columns: pulumi.StringArray{
 * pulumi.String("Date"),
 * pulumi.String("MeterId"),
 * pulumi.String("ResourceId"),
 * pulumi.String("ResourceLocation"),
 * pulumi.String("Quantity"),
 * },
 * },
 * Granularity: pulumi.String("Daily"),
 * },
 * Timeframe: pulumi.String("MonthToDate"),
 * Type: pulumi.String("ActualCost"),
 * },
 * DeliveryInfo: costmanagement.ExportDeliveryInfoResponse{
 * Destination: &costmanagement.ExportDeliveryDestinationArgs{
 * Container: pulumi.String("exports"),
 * ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 * RootFolderPath: pulumi.String("ad-hoc"),
 * },
 * },
 * ExportName: pulumi.String("TestExport"),
 * Format: pulumi.String("Csv"),
 * Schedule: costmanagement.ExportScheduleResponse{
 * Recurrence: pulumi.String("Weekly"),
 * RecurrencePeriod: &costmanagement.ExportRecurrencePeriodArgs{
 * From: pulumi.String("2020-06-01T00:00:00Z"),
 * To: pulumi.String("2020-10-31T00:00:00Z"),
 * },
 * Status: pulumi.String("Active"),
 * },
 * Scope: pulumi.String("providers/Microsoft.Billing/billingAccounts/12/departments/1234"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Export;
 * import com.pulumi.azurenative.costmanagement.ExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var export = new Export("export", ExportArgs.builder()
 *             .definition(Map.ofEntries(
 *                 Map.entry("dataSet", Map.ofEntries(
 *                     Map.entry("configuration", Map.of("columns",
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity")),
 *                     Map.entry("granularity", "Daily")
 *                 )),
 *                 Map.entry("timeframe", "MonthToDate"),
 *                 Map.entry("type", "ActualCost")
 *             ))
 *             .deliveryInfo(Map.of("destination", Map.ofEntries(
 *                 Map.entry("container", "exports"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 *                 Map.entry("rootFolderPath", "ad-hoc")
 *             )))
 *             .exportName("TestExport")
 *             .format("Csv")
 *             .schedule(Map.ofEntries(
 *                 Map.entry("recurrence", "Weekly"),
 *                 Map.entry("recurrencePeriod", Map.ofEntries(
 *                     Map.entry("from", "2020-06-01T00:00:00Z"),
 *                     Map.entry("to", "2020-10-31T00:00:00Z")
 *                 )),
 *                 Map.entry("status", "Active")
 *             ))
 *             .scope("providers/Microsoft.Billing/billingAccounts/12/departments/1234")
 *             .build());
 *     }
 * }
 * ```
 * ### ExportCreateOrUpdateByEnrollmentAccount
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var export = new AzureNative.CostManagement.Export("export", new()
 *     {
 *         Definition = new AzureNative.CostManagement.Inputs.ExportDefinitionArgs
 *         {
 *             DataSet = new AzureNative.CostManagement.Inputs.ExportDatasetArgs
 *             {
 *                 Configuration = new AzureNative.CostManagement.Inputs.ExportDatasetConfigurationArgs
 *                 {
 *                     Columns = new[]
 *                     {
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity",
 *                     },
 *                 },
 *                 Granularity = "Daily",
 *             },
 *             Timeframe = "MonthToDate",
 *             Type = "ActualCost",
 *         },
 *         DeliveryInfo = new AzureNative.CostManagement.Inputs.ExportDeliveryInfoArgs
 *         {
 *             Destination = new AzureNative.CostManagement.Inputs.ExportDeliveryDestinationArgs
 *             {
 *                 Container = "exports",
 *                 ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182",
 *                 RootFolderPath = "ad-hoc",
 *             },
 *         },
 *         ExportName = "TestExport",
 *         Format = "Csv",
 *         Schedule = new AzureNative.CostManagement.Inputs.ExportScheduleArgs
 *         {
 *             Recurrence = "Weekly",
 *             RecurrencePeriod = new AzureNative.CostManagement.Inputs.ExportRecurrencePeriodArgs
 *             {
 *                 From = "2020-06-01T00:00:00Z",
 *                 To = "2020-10-31T00:00:00Z",
 *             },
 *             Status = "Active",
 *         },
 *         Scope = "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := costmanagement.NewExport(ctx, "export", &costmanagement.ExportArgs{
 * Definition: costmanagement.ExportDefinitionResponse{
 * DataSet: interface{}{
 * Configuration: &costmanagement.ExportDatasetConfigurationArgs{
 * Columns: pulumi.StringArray{
 * pulumi.String("Date"),
 * pulumi.String("MeterId"),
 * pulumi.String("ResourceId"),
 * pulumi.String("ResourceLocation"),
 * pulumi.String("Quantity"),
 * },
 * },
 * Granularity: pulumi.String("Daily"),
 * },
 * Timeframe: pulumi.String("MonthToDate"),
 * Type: pulumi.String("ActualCost"),
 * },
 * DeliveryInfo: costmanagement.ExportDeliveryInfoResponse{
 * Destination: &costmanagement.ExportDeliveryDestinationArgs{
 * Container: pulumi.String("exports"),
 * ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 * RootFolderPath: pulumi.String("ad-hoc"),
 * },
 * },
 * ExportName: pulumi.String("TestExport"),
 * Format: pulumi.String("Csv"),
 * Schedule: costmanagement.ExportScheduleResponse{
 * Recurrence: pulumi.String("Weekly"),
 * RecurrencePeriod: &costmanagement.ExportRecurrencePeriodArgs{
 * From: pulumi.String("2020-06-01T00:00:00Z"),
 * To: pulumi.String("2020-10-31T00:00:00Z"),
 * },
 * Status: pulumi.String("Active"),
 * },
 * Scope: pulumi.String("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Export;
 * import com.pulumi.azurenative.costmanagement.ExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var export = new Export("export", ExportArgs.builder()
 *             .definition(Map.ofEntries(
 *                 Map.entry("dataSet", Map.ofEntries(
 *                     Map.entry("configuration", Map.of("columns",
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity")),
 *                     Map.entry("granularity", "Daily")
 *                 )),
 *                 Map.entry("timeframe", "MonthToDate"),
 *                 Map.entry("type", "ActualCost")
 *             ))
 *             .deliveryInfo(Map.of("destination", Map.ofEntries(
 *                 Map.entry("container", "exports"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 *                 Map.entry("rootFolderPath", "ad-hoc")
 *             )))
 *             .exportName("TestExport")
 *             .format("Csv")
 *             .schedule(Map.ofEntries(
 *                 Map.entry("recurrence", "Weekly"),
 *                 Map.entry("recurrencePeriod", Map.ofEntries(
 *                     Map.entry("from", "2020-06-01T00:00:00Z"),
 *                     Map.entry("to", "2020-10-31T00:00:00Z")
 *                 )),
 *                 Map.entry("status", "Active")
 *             ))
 *             .scope("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456")
 *             .build());
 *     }
 * }
 * ```
 * ### ExportCreateOrUpdateByManagementGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var export = new AzureNative.CostManagement.Export("export", new()
 *     {
 *         Definition = new AzureNative.CostManagement.Inputs.ExportDefinitionArgs
 *         {
 *             DataSet = new AzureNative.CostManagement.Inputs.ExportDatasetArgs
 *             {
 *                 Configuration = new AzureNative.CostManagement.Inputs.ExportDatasetConfigurationArgs
 *                 {
 *                     Columns = new[]
 *                     {
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity",
 *                     },
 *                 },
 *                 Granularity = "Daily",
 *             },
 *             Timeframe = "MonthToDate",
 *             Type = "ActualCost",
 *         },
 *         DeliveryInfo = new AzureNative.CostManagement.Inputs.ExportDeliveryInfoArgs
 *         {
 *             Destination = new AzureNative.CostManagement.Inputs.ExportDeliveryDestinationArgs
 *             {
 *                 Container = "exports",
 *                 ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182",
 *                 RootFolderPath = "ad-hoc",
 *             },
 *         },
 *         ExportName = "TestExport",
 *         Format = "Csv",
 *         Schedule = new AzureNative.CostManagement.Inputs.ExportScheduleArgs
 *         {
 *             Recurrence = "Weekly",
 *             RecurrencePeriod = new AzureNative.CostManagement.Inputs.ExportRecurrencePeriodArgs
 *             {
 *                 From = "2020-06-01T00:00:00Z",
 *                 To = "2020-10-31T00:00:00Z",
 *             },
 *             Status = "Active",
 *         },
 *         Scope = "providers/Microsoft.Management/managementGroups/TestMG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := costmanagement.NewExport(ctx, "export", &costmanagement.ExportArgs{
 * Definition: costmanagement.ExportDefinitionResponse{
 * DataSet: interface{}{
 * Configuration: &costmanagement.ExportDatasetConfigurationArgs{
 * Columns: pulumi.StringArray{
 * pulumi.String("Date"),
 * pulumi.String("MeterId"),
 * pulumi.String("ResourceId"),
 * pulumi.String("ResourceLocation"),
 * pulumi.String("Quantity"),
 * },
 * },
 * Granularity: pulumi.String("Daily"),
 * },
 * Timeframe: pulumi.String("MonthToDate"),
 * Type: pulumi.String("ActualCost"),
 * },
 * DeliveryInfo: costmanagement.ExportDeliveryInfoResponse{
 * Destination: &costmanagement.ExportDeliveryDestinationArgs{
 * Container: pulumi.String("exports"),
 * ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 * RootFolderPath: pulumi.String("ad-hoc"),
 * },
 * },
 * ExportName: pulumi.String("TestExport"),
 * Format: pulumi.String("Csv"),
 * Schedule: costmanagement.ExportScheduleResponse{
 * Recurrence: pulumi.String("Weekly"),
 * RecurrencePeriod: &costmanagement.ExportRecurrencePeriodArgs{
 * From: pulumi.String("2020-06-01T00:00:00Z"),
 * To: pulumi.String("2020-10-31T00:00:00Z"),
 * },
 * Status: pulumi.String("Active"),
 * },
 * Scope: pulumi.String("providers/Microsoft.Management/managementGroups/TestMG"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Export;
 * import com.pulumi.azurenative.costmanagement.ExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var export = new Export("export", ExportArgs.builder()
 *             .definition(Map.ofEntries(
 *                 Map.entry("dataSet", Map.ofEntries(
 *                     Map.entry("configuration", Map.of("columns",
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity")),
 *                     Map.entry("granularity", "Daily")
 *                 )),
 *                 Map.entry("timeframe", "MonthToDate"),
 *                 Map.entry("type", "ActualCost")
 *             ))
 *             .deliveryInfo(Map.of("destination", Map.ofEntries(
 *                 Map.entry("container", "exports"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 *                 Map.entry("rootFolderPath", "ad-hoc")
 *             )))
 *             .exportName("TestExport")
 *             .format("Csv")
 *             .schedule(Map.ofEntries(
 *                 Map.entry("recurrence", "Weekly"),
 *                 Map.entry("recurrencePeriod", Map.ofEntries(
 *                     Map.entry("from", "2020-06-01T00:00:00Z"),
 *                     Map.entry("to", "2020-10-31T00:00:00Z")
 *                 )),
 *                 Map.entry("status", "Active")
 *             ))
 *             .scope("providers/Microsoft.Management/managementGroups/TestMG")
 *             .build());
 *     }
 * }
 * ```
 * ### ExportCreateOrUpdateByResourceGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var export = new AzureNative.CostManagement.Export("export", new()
 *     {
 *         Definition = new AzureNative.CostManagement.Inputs.ExportDefinitionArgs
 *         {
 *             DataSet = new AzureNative.CostManagement.Inputs.ExportDatasetArgs
 *             {
 *                 Configuration = new AzureNative.CostManagement.Inputs.ExportDatasetConfigurationArgs
 *                 {
 *                     Columns = new[]
 *                     {
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity",
 *                     },
 *                 },
 *                 Granularity = "Daily",
 *             },
 *             Timeframe = "MonthToDate",
 *             Type = "ActualCost",
 *         },
 *         DeliveryInfo = new AzureNative.CostManagement.Inputs.ExportDeliveryInfoArgs
 *         {
 *             Destination = new AzureNative.CostManagement.Inputs.ExportDeliveryDestinationArgs
 *             {
 *                 Container = "exports",
 *                 ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182",
 *                 RootFolderPath = "ad-hoc",
 *             },
 *         },
 *         ExportName = "TestExport",
 *         Format = "Csv",
 *         Schedule = new AzureNative.CostManagement.Inputs.ExportScheduleArgs
 *         {
 *             Recurrence = "Weekly",
 *             RecurrencePeriod = new AzureNative.CostManagement.Inputs.ExportRecurrencePeriodArgs
 *             {
 *                 From = "2020-06-01T00:00:00Z",
 *                 To = "2020-10-31T00:00:00Z",
 *             },
 *             Status = "Active",
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := costmanagement.NewExport(ctx, "export", &costmanagement.ExportArgs{
 * Definition: costmanagement.ExportDefinitionResponse{
 * DataSet: interface{}{
 * Configuration: &costmanagement.ExportDatasetConfigurationArgs{
 * Columns: pulumi.StringArray{
 * pulumi.String("Date"),
 * pulumi.String("MeterId"),
 * pulumi.String("ResourceId"),
 * pulumi.String("ResourceLocation"),
 * pulumi.String("Quantity"),
 * },
 * },
 * Granularity: pulumi.String("Daily"),
 * },
 * Timeframe: pulumi.String("MonthToDate"),
 * Type: pulumi.String("ActualCost"),
 * },
 * DeliveryInfo: costmanagement.ExportDeliveryInfoResponse{
 * Destination: &costmanagement.ExportDeliveryDestinationArgs{
 * Container: pulumi.String("exports"),
 * ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 * RootFolderPath: pulumi.String("ad-hoc"),
 * },
 * },
 * ExportName: pulumi.String("TestExport"),
 * Format: pulumi.String("Csv"),
 * Schedule: costmanagement.ExportScheduleResponse{
 * Recurrence: pulumi.String("Weekly"),
 * RecurrencePeriod: &costmanagement.ExportRecurrencePeriodArgs{
 * From: pulumi.String("2020-06-01T00:00:00Z"),
 * To: pulumi.String("2020-10-31T00:00:00Z"),
 * },
 * Status: pulumi.String("Active"),
 * },
 * Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Export;
 * import com.pulumi.azurenative.costmanagement.ExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var export = new Export("export", ExportArgs.builder()
 *             .definition(Map.ofEntries(
 *                 Map.entry("dataSet", Map.ofEntries(
 *                     Map.entry("configuration", Map.of("columns",
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity")),
 *                     Map.entry("granularity", "Daily")
 *                 )),
 *                 Map.entry("timeframe", "MonthToDate"),
 *                 Map.entry("type", "ActualCost")
 *             ))
 *             .deliveryInfo(Map.of("destination", Map.ofEntries(
 *                 Map.entry("container", "exports"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 *                 Map.entry("rootFolderPath", "ad-hoc")
 *             )))
 *             .exportName("TestExport")
 *             .format("Csv")
 *             .schedule(Map.ofEntries(
 *                 Map.entry("recurrence", "Weekly"),
 *                 Map.entry("recurrencePeriod", Map.ofEntries(
 *                     Map.entry("from", "2020-06-01T00:00:00Z"),
 *                     Map.entry("to", "2020-10-31T00:00:00Z")
 *                 )),
 *                 Map.entry("status", "Active")
 *             ))
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG")
 *             .build());
 *     }
 * }
 * ```
 * ### ExportCreateOrUpdateBySubscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var export = new AzureNative.CostManagement.Export("export", new()
 *     {
 *         Definition = new AzureNative.CostManagement.Inputs.ExportDefinitionArgs
 *         {
 *             DataSet = new AzureNative.CostManagement.Inputs.ExportDatasetArgs
 *             {
 *                 Configuration = new AzureNative.CostManagement.Inputs.ExportDatasetConfigurationArgs
 *                 {
 *                     Columns = new[]
 *                     {
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity",
 *                     },
 *                 },
 *                 Granularity = "Daily",
 *             },
 *             Timeframe = "MonthToDate",
 *             Type = "ActualCost",
 *         },
 *         DeliveryInfo = new AzureNative.CostManagement.Inputs.ExportDeliveryInfoArgs
 *         {
 *             Destination = new AzureNative.CostManagement.Inputs.ExportDeliveryDestinationArgs
 *             {
 *                 Container = "exports",
 *                 ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182",
 *                 RootFolderPath = "ad-hoc",
 *             },
 *         },
 *         ExportName = "TestExport",
 *         Format = "Csv",
 *         Schedule = new AzureNative.CostManagement.Inputs.ExportScheduleArgs
 *         {
 *             Recurrence = "Weekly",
 *             RecurrencePeriod = new AzureNative.CostManagement.Inputs.ExportRecurrencePeriodArgs
 *             {
 *                 From = "2020-06-01T00:00:00Z",
 *                 To = "2020-10-31T00:00:00Z",
 *             },
 *             Status = "Active",
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := costmanagement.NewExport(ctx, "export", &costmanagement.ExportArgs{
 * Definition: costmanagement.ExportDefinitionResponse{
 * DataSet: interface{}{
 * Configuration: &costmanagement.ExportDatasetConfigurationArgs{
 * Columns: pulumi.StringArray{
 * pulumi.String("Date"),
 * pulumi.String("MeterId"),
 * pulumi.String("ResourceId"),
 * pulumi.String("ResourceLocation"),
 * pulumi.String("Quantity"),
 * },
 * },
 * Granularity: pulumi.String("Daily"),
 * },
 * Timeframe: pulumi.String("MonthToDate"),
 * Type: pulumi.String("ActualCost"),
 * },
 * DeliveryInfo: costmanagement.ExportDeliveryInfoResponse{
 * Destination: &costmanagement.ExportDeliveryDestinationArgs{
 * Container: pulumi.String("exports"),
 * ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 * RootFolderPath: pulumi.String("ad-hoc"),
 * },
 * },
 * ExportName: pulumi.String("TestExport"),
 * Format: pulumi.String("Csv"),
 * Schedule: costmanagement.ExportScheduleResponse{
 * Recurrence: pulumi.String("Weekly"),
 * RecurrencePeriod: &costmanagement.ExportRecurrencePeriodArgs{
 * From: pulumi.String("2020-06-01T00:00:00Z"),
 * To: pulumi.String("2020-10-31T00:00:00Z"),
 * },
 * Status: pulumi.String("Active"),
 * },
 * Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Export;
 * import com.pulumi.azurenative.costmanagement.ExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var export = new Export("export", ExportArgs.builder()
 *             .definition(Map.ofEntries(
 *                 Map.entry("dataSet", Map.ofEntries(
 *                     Map.entry("configuration", Map.of("columns",
 *                         "Date",
 *                         "MeterId",
 *                         "ResourceId",
 *                         "ResourceLocation",
 *                         "Quantity")),
 *                     Map.entry("granularity", "Daily")
 *                 )),
 *                 Map.entry("timeframe", "MonthToDate"),
 *                 Map.entry("type", "ActualCost")
 *             ))
 *             .deliveryInfo(Map.of("destination", Map.ofEntries(
 *                 Map.entry("container", "exports"),
 *                 Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
 *                 Map.entry("rootFolderPath", "ad-hoc")
 *             )))
 *             .exportName("TestExport")
 *             .format("Csv")
 *             .schedule(Map.ofEntries(
 *                 Map.entry("recurrence", "Weekly"),
 *                 Map.entry("recurrencePeriod", Map.ofEntries(
 *                     Map.entry("from", "2020-06-01T00:00:00Z"),
 *                     Map.entry("to", "2020-10-31T00:00:00Z")
 *                 )),
 *                 Map.entry("status", "Active")
 *             ))
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:Export TestExport /{scope}/providers/Microsoft.CostManagement/exports/{exportName}
 * ```
 * @property definition Has the definition for the export.
 * @property deliveryInfo Has delivery information for the export.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property exportName Export Name.
 * @property format The format of the export being delivered. Currently only 'Csv' is supported.
 * @property partitionData If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for Microsoft Customer Agreement commerce scopes.
 * @property schedule Has schedule information for the export.
 * @property scope The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope, and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
 */
public data class ExportArgs(
    public val definition: Output<ExportDefinitionArgs>? = null,
    public val deliveryInfo: Output<ExportDeliveryInfoArgs>? = null,
    public val eTag: Output<String>? = null,
    public val exportName: Output<String>? = null,
    public val format: Output<Either<String, FormatType>>? = null,
    public val partitionData: Output<Boolean>? = null,
    public val schedule: Output<ExportScheduleArgs>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.ExportArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.ExportArgs =
        com.pulumi.azurenative.costmanagement.ExportArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deliveryInfo(deliveryInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .exportName(exportName?.applyValue({ args0 -> args0 }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .partitionData(partitionData?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportArgs].
 */
@PulumiTagMarker
public class ExportArgsBuilder internal constructor() {
    private var definition: Output<ExportDefinitionArgs>? = null

    private var deliveryInfo: Output<ExportDeliveryInfoArgs>? = null

    private var eTag: Output<String>? = null

    private var exportName: Output<String>? = null

    private var format: Output<Either<String, FormatType>>? = null

    private var partitionData: Output<Boolean>? = null

    private var schedule: Output<ExportScheduleArgs>? = null

    private var scope: Output<String>? = null

    /**
     * @param value Has the definition for the export.
     */
    @JvmName("snkbkcduofdjvnyc")
    public suspend fun definition(`value`: Output<ExportDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value Has delivery information for the export.
     */
    @JvmName("qvwnldyccbtcffpk")
    public suspend fun deliveryInfo(`value`: Output<ExportDeliveryInfoArgs>) {
        this.deliveryInfo = value
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("kaimcynmtjixddth")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Export Name.
     */
    @JvmName("rmlunywrepkixqjb")
    public suspend fun exportName(`value`: Output<String>) {
        this.exportName = value
    }

    /**
     * @param value The format of the export being delivered. Currently only 'Csv' is supported.
     */
    @JvmName("ebvubsxnwnkkmmuq")
    public suspend fun format(`value`: Output<Either<String, FormatType>>) {
        this.format = value
    }

    /**
     * @param value If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for Microsoft Customer Agreement commerce scopes.
     */
    @JvmName("ianojkjcrmjcxryg")
    public suspend fun partitionData(`value`: Output<Boolean>) {
        this.partitionData = value
    }

    /**
     * @param value Has schedule information for the export.
     */
    @JvmName("othvsttpgifbmkcf")
    public suspend fun schedule(`value`: Output<ExportScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope, and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
     */
    @JvmName("ooadjsmypqchqyhy")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Has the definition for the export.
     */
    @JvmName("tacarymikgyombfo")
    public suspend fun definition(`value`: ExportDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument Has the definition for the export.
     */
    @JvmName("glhddwfcmphededu")
    public suspend fun definition(argument: suspend ExportDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ExportDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value Has delivery information for the export.
     */
    @JvmName("vljwcchggwwfymew")
    public suspend fun deliveryInfo(`value`: ExportDeliveryInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryInfo = mapped
    }

    /**
     * @param argument Has delivery information for the export.
     */
    @JvmName("ncsaubeilftowbcw")
    public suspend fun deliveryInfo(argument: suspend ExportDeliveryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ExportDeliveryInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryInfo = mapped
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("oaltxyvtsomojyur")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Export Name.
     */
    @JvmName("vrkjguwhvohjwybc")
    public suspend fun exportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportName = mapped
    }

    /**
     * @param value The format of the export being delivered. Currently only 'Csv' is supported.
     */
    @JvmName("nctadlabpgqqusvq")
    public suspend fun format(`value`: Either<String, FormatType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The format of the export being delivered. Currently only 'Csv' is supported.
     */
    @JvmName("agxaexqpgkctvvmm")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FormatType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The format of the export being delivered. Currently only 'Csv' is supported.
     */
    @JvmName("qykmgslxjhlwokjj")
    public fun format(`value`: FormatType) {
        val toBeMapped = Either.ofRight<String, FormatType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for Microsoft Customer Agreement commerce scopes.
     */
    @JvmName("jwaxiohoitfvawse")
    public suspend fun partitionData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionData = mapped
    }

    /**
     * @param value Has schedule information for the export.
     */
    @JvmName("vfrrjgtkyxccwyvn")
    public suspend fun schedule(`value`: ExportScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Has schedule information for the export.
     */
    @JvmName("kggohafdwgnhwrmo")
    public suspend fun schedule(argument: suspend ExportScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = ExportScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope, and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
     */
    @JvmName("rqbtkxjveidayguw")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): ExportArgs = ExportArgs(
        definition = definition,
        deliveryInfo = deliveryInfo,
        eTag = eTag,
        exportName = exportName,
        format = format,
        partitionData = partitionData,
        schedule = schedule,
        scope = scope,
    )
}
