@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportDefinitionResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportDeliveryInfoResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportScheduleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportDefinitionResponse.Companion.toKotlin as reportDefinitionResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportDeliveryInfoResponse.Companion.toKotlin as reportDeliveryInfoResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportScheduleResponse.Companion.toKotlin as reportScheduleResponseToKotlin

/**
 * Builder for [Report].
 */
@PulumiTagMarker
public class ReportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReportArgs = ReportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReportArgsBuilder.() -> Unit) {
        val builder = ReportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Report {
        val builtJavaResource = com.pulumi.azurenative.costmanagement.Report(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Report(builtJavaResource)
    }
}

/**
 * A report resource.
 * Azure REST API version: 2018-08-01-preview. Prior API version in Azure Native 1.x: 2018-08-01-preview.
 */
public class Report internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.Report,
) : KotlinCustomResource(javaResource, ReportMapper) {
    /**
     * Has definition for the report.
     */
    public val definition: Output<ReportDefinitionResponse>
        get() = javaResource.definition().applyValue({ args0 ->
            args0.let({ args0 ->
                reportDefinitionResponseToKotlin(args0)
            })
        })

    /**
     * Has delivery information for the report.
     */
    public val deliveryInfo: Output<ReportDeliveryInfoResponse>
        get() = javaResource.deliveryInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                reportDeliveryInfoResponseToKotlin(args0)
            })
        })

    /**
     * The format of the report being delivered.
     */
    public val format: Output<String>?
        get() = javaResource.format().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Has schedule information for the report.
     */
    public val schedule: Output<ReportScheduleResponse>?
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    reportScheduleResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReportMapper : ResourceMapper<Report> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.Report::class == javaResource::class

    override fun map(javaResource: Resource): Report = Report(
        javaResource as
            com.pulumi.azurenative.costmanagement.Report,
    )
}

/**
 * @see [Report].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Report].
 */
public suspend fun report(name: String, block: suspend ReportResourceBuilder.() -> Unit): Report {
    val builder = ReportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Report].
 * @param name The _unique_ name of the resulting resource.
 */
public fun report(name: String): Report {
    val builder = ReportResourceBuilder()
    builder.name(name)
    return builder.build()
}
