@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.TagInheritanceSettingArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.TagInheritancePropertiesArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.TagInheritancePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Tag Inheritance Setting definition.
 * Azure REST API version: 2022-10-05-preview.
 * ## Example Usage
 * ### CreateOrUpdateSettingByScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagInheritanceSetting = new AzureNative.CostManagement.TagInheritanceSetting("tagInheritanceSetting", new()
 *     {
 *         Kind = "taginheritance",
 *         Properties = new AzureNative.CostManagement.Inputs.TagInheritancePropertiesArgs
 *         {
 *             PreferContainerTags = false,
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         Type = "taginheritance",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewTagInheritanceSetting(ctx, "tagInheritanceSetting", &costmanagement.TagInheritanceSettingArgs{
 * 			Kind: pulumi.String("taginheritance"),
 * 			Properties: &costmanagement.TagInheritancePropertiesArgs{
 * 				PreferContainerTags: pulumi.Bool(false),
 * 			},
 * 			Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			Type:  pulumi.String("taginheritance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.TagInheritanceSetting;
 * import com.pulumi.azurenative.costmanagement.TagInheritanceSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagInheritanceSetting = new TagInheritanceSetting("tagInheritanceSetting", TagInheritanceSettingArgs.builder()
 *             .kind("taginheritance")
 *             .properties(Map.of("preferContainerTags", false))
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .type("taginheritance")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:TagInheritanceSetting taginheritance /{scope}/providers/Microsoft.CostManagement/settings/{type}
 * ```
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property kind Specifies the kind of settings.
 * Expected value is 'taginheritance'.
 * @property properties The properties of the tag inheritance setting.
 * @property scope The scope associated with this setting. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billing profile scope.
 * @property type Setting type.
 */
public data class TagInheritanceSettingArgs(
    public val eTag: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val properties: Output<TagInheritancePropertiesArgs>? = null,
    public val scope: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.TagInheritanceSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.TagInheritanceSettingArgs =
        com.pulumi.azurenative.costmanagement.TagInheritanceSettingArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagInheritanceSettingArgs].
 */
@PulumiTagMarker
public class TagInheritanceSettingArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var kind: Output<String>? = null

    private var properties: Output<TagInheritancePropertiesArgs>? = null

    private var scope: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("hhsdfnuhkvoxbskq")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Specifies the kind of settings.
     * Expected value is 'taginheritance'.
     */
    @JvmName("kgbfhaineipughuw")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The properties of the tag inheritance setting.
     */
    @JvmName("ogovxsyobqcirfvu")
    public suspend fun properties(`value`: Output<TagInheritancePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The scope associated with this setting. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billing profile scope.
     */
    @JvmName("jkwnjrhidjpmwwlb")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Setting type.
     */
    @JvmName("lsngnqnwmuyugrfi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("icshkffbvhqhunnf")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Specifies the kind of settings.
     * Expected value is 'taginheritance'.
     */
    @JvmName("dsindsmrhwcbnnbf")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The properties of the tag inheritance setting.
     */
    @JvmName("gmvsjkiyurmhxfyh")
    public suspend fun properties(`value`: TagInheritancePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of the tag inheritance setting.
     */
    @JvmName("gayrvuhvnumyyjva")
    public suspend fun properties(argument: suspend TagInheritancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TagInheritancePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The scope associated with this setting. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billing profile scope.
     */
    @JvmName("uxbqcuunobuqovcr")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Setting type.
     */
    @JvmName("jhblpikdmsyrnxoj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TagInheritanceSettingArgs = TagInheritanceSettingArgs(
        eTag = eTag,
        kind = kind,
        properties = properties,
        scope = scope,
        type = type,
    )
}
