@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The category of the budget.
 * - 'Cost' defines a Budget.
 * - 'ReservationUtilization' defines a Reservation Utilization Alert Rule.
 */
public enum class CategoryType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.CategoryType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.CategoryType> {
    /**
     * A Budget that evaluates monetary cost of Azure resources against an amount, and alerts based on a configured notification threshold.
     */
    Cost(com.pulumi.azurenative.costmanagement.enums.CategoryType.Cost),

    /**
     * An Alert Rule that evaluates the utilization percentage of Azure Reservations, and alerts based on a configured notification threshold.
     */
    ReservationUtilization(com.pulumi.azurenative.costmanagement.enums.CategoryType.ReservationUtilization),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.CategoryType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.CategoryType):
            CategoryType = CategoryType.values().first { it.javaValue == javaType }
    }
}
