@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
 */
public enum class ExportType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.ExportType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.ExportType> {
    Usage(com.pulumi.azurenative.costmanagement.enums.ExportType.Usage),
    ActualCost(com.pulumi.azurenative.costmanagement.enums.ExportType.ActualCost),
    AmortizedCost(com.pulumi.azurenative.costmanagement.enums.ExportType.AmortizedCost),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.ExportType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.ExportType):
            ExportType = ExportType.values().first { it.javaValue == javaType }
    }
}
