@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Status of the scheduled action.
 */
public enum class ScheduledActionStatus(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.ScheduledActionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.ScheduledActionStatus> {
    /**
     * Scheduled action is saved but will not be run.
     */
    Disabled(com.pulumi.azurenative.costmanagement.enums.ScheduledActionStatus.Disabled),

    /**
     * Scheduled action is saved and will be run.
     */
    Enabled(com.pulumi.azurenative.costmanagement.enums.ScheduledActionStatus.Enabled),

    /**
     * Scheduled action is expired.
     */
    Expired(com.pulumi.azurenative.costmanagement.enums.ScheduledActionStatus.Expired),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.ScheduledActionStatus =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.ScheduledActionStatus):
            ScheduledActionStatus = ScheduledActionStatus.values().first { it.javaValue == javaType }
    }
}
