@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.BudgetFilterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Dimensions or Tags to filter a budget by.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property dimensions Has comparison expression for a dimension.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * Supported dimension names for **CategoryType: ReservationUtilization**
 * - ReservationId
 * - ReservedResourceType
 * @property tags Has comparison expression for a tag.
 *  Supported for CategoryType(s): Cost.
 */
public data class BudgetFilterPropertiesArgs(
    public val dimensions: Output<BudgetComparisonExpressionArgs>? = null,
    public val tags: Output<BudgetComparisonExpressionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.BudgetFilterPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.BudgetFilterPropertiesArgs =
        com.pulumi.azurenative.costmanagement.inputs.BudgetFilterPropertiesArgs.builder()
            .dimensions(dimensions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BudgetFilterPropertiesArgs].
 */
@PulumiTagMarker
public class BudgetFilterPropertiesArgsBuilder internal constructor() {
    private var dimensions: Output<BudgetComparisonExpressionArgs>? = null

    private var tags: Output<BudgetComparisonExpressionArgs>? = null

    /**
     * @param value Has comparison expression for a dimension.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * Supported dimension names for **CategoryType: ReservationUtilization**
     * - ReservationId
     * - ReservedResourceType
     */
    @JvmName("kuxhtwlmlqyowwgt")
    public suspend fun dimensions(`value`: Output<BudgetComparisonExpressionArgs>) {
        this.dimensions = value
    }

    /**
     * @param value Has comparison expression for a tag.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("yjemkhnenmscyhmh")
    public suspend fun tags(`value`: Output<BudgetComparisonExpressionArgs>) {
        this.tags = value
    }

    /**
     * @param value Has comparison expression for a dimension.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * Supported dimension names for **CategoryType: ReservationUtilization**
     * - ReservationId
     * - ReservedResourceType
     */
    @JvmName("feflhjsemvefqltc")
    public suspend fun dimensions(`value`: BudgetComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Has comparison expression for a dimension.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * Supported dimension names for **CategoryType: ReservationUtilization**
     * - ReservationId
     * - ReservedResourceType
     */
    @JvmName("djaxjmvaryvelypt")
    public suspend
    fun dimensions(argument: suspend BudgetComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetComparisonExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param value Has comparison expression for a tag.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("iqtubxwfvgpsfial")
    public suspend fun tags(`value`: BudgetComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Has comparison expression for a tag.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("ymxlkvjthvbuytpy")
    public suspend fun tags(argument: suspend BudgetComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetComparisonExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): BudgetFilterPropertiesArgs = BudgetFilterPropertiesArgs(
        dimensions = dimensions,
        tags = tags,
    )
}
