@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ExportDatasetConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The export dataset configuration. Allows columns to be selected for the export. If not provided then the export will include all available columns.
 * @property columns Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
 */
public data class ExportDatasetConfigurationArgs(
    public val columns: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ExportDatasetConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ExportDatasetConfigurationArgs =
        com.pulumi.azurenative.costmanagement.inputs.ExportDatasetConfigurationArgs.builder()
            .columns(columns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ExportDatasetConfigurationArgs].
 */
@PulumiTagMarker
public class ExportDatasetConfigurationArgsBuilder internal constructor() {
    private var columns: Output<List<String>>? = null

    /**
     * @param value Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
     */
    @JvmName("uvkglaugmctqrwtt")
    public suspend fun columns(`value`: Output<List<String>>) {
        this.columns = value
    }

    @JvmName("rgtglmlsbkapwjng")
    public suspend fun columns(vararg values: Output<String>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
     */
    @JvmName("nnvfboppgdihayot")
    public suspend fun columns(values: List<Output<String>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
     */
    @JvmName("enowntdnptguhvgq")
    public suspend fun columns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param values Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
     */
    @JvmName("mdovwwqgxufhdxbm")
    public suspend fun columns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    internal fun build(): ExportDatasetConfigurationArgs = ExportDatasetConfigurationArgs(
        columns = columns,
    )
}
