@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ExportDeliveryDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This represents the blob storage account location where exports of costs will be delivered. There are two ways to configure the destination. The approach recommended for most customers is to specify the resourceId of the storage account. This requires a one-time registration of the account's subscription with the Microsoft.CostManagementExports resource provider in order to give Cost Management services access to the storage. When creating an export in the Azure portal this registration is performed automatically but API users may need to register the subscription explicitly (for more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services ). Another way to configure the destination is available ONLY to Partners with a Microsoft Partner Agreement plan who are global admins of their billing account. These Partners, instead of specifying the resourceId of a storage account, can specify the storage account name along with a SAS token for the account. This allows exports of costs to a storage account in any tenant. The SAS token should be created for the blob service with Service/Container/Object resource types and with Read/Write/Delete/List/Add/Create permissions (for more information see https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key ).
 * @property container The name of the container where exports will be uploaded. If the container does not exist it will be created.
 * @property resourceId The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified.
 * @property rootFolderPath The name of the directory where exports will be uploaded.
 * @property sasToken A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified.
 * @property storageAccount The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId.
 */
public data class ExportDeliveryDestinationArgs(
    public val container: Output<String>,
    public val resourceId: Output<String>? = null,
    public val rootFolderPath: Output<String>? = null,
    public val sasToken: Output<String>? = null,
    public val storageAccount: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ExportDeliveryDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ExportDeliveryDestinationArgs =
        com.pulumi.azurenative.costmanagement.inputs.ExportDeliveryDestinationArgs.builder()
            .container(container.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .rootFolderPath(rootFolderPath?.applyValue({ args0 -> args0 }))
            .sasToken(sasToken?.applyValue({ args0 -> args0 }))
            .storageAccount(storageAccount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportDeliveryDestinationArgs].
 */
@PulumiTagMarker
public class ExportDeliveryDestinationArgsBuilder internal constructor() {
    private var container: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var rootFolderPath: Output<String>? = null

    private var sasToken: Output<String>? = null

    private var storageAccount: Output<String>? = null

    /**
     * @param value The name of the container where exports will be uploaded. If the container does not exist it will be created.
     */
    @JvmName("vkjcelrdtycwjuwd")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified.
     */
    @JvmName("skcdhqnfcbowjvvm")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The name of the directory where exports will be uploaded.
     */
    @JvmName("donqfcoyqarlyqjo")
    public suspend fun rootFolderPath(`value`: Output<String>) {
        this.rootFolderPath = value
    }

    /**
     * @param value A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified.
     */
    @JvmName("xtshjhaaxgydegvi")
    public suspend fun sasToken(`value`: Output<String>) {
        this.sasToken = value
    }

    /**
     * @param value The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId.
     */
    @JvmName("klrqxvnuwymromls")
    public suspend fun storageAccount(`value`: Output<String>) {
        this.storageAccount = value
    }

    /**
     * @param value The name of the container where exports will be uploaded. If the container does not exist it will be created.
     */
    @JvmName("ebppfxvbfciqpsvw")
    public suspend fun container(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified.
     */
    @JvmName("dssdgvgqufxfyrfe")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The name of the directory where exports will be uploaded.
     */
    @JvmName("knpdfiixnpnphcdx")
    public suspend fun rootFolderPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootFolderPath = mapped
    }

    /**
     * @param value A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified.
     */
    @JvmName("fgikoeorecmfagbb")
    public suspend fun sasToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param value The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId.
     */
    @JvmName("xgowavceryajuwvf")
    public suspend fun storageAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccount = mapped
    }

    internal fun build(): ExportDeliveryDestinationArgs = ExportDeliveryDestinationArgs(
        container = container ?: throw PulumiNullFieldException("container"),
        resourceId = resourceId,
        rootFolderPath = rootFolderPath,
        sasToken = sasToken,
        storageAccount = storageAccount,
    )
}
