@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ExportDeliveryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The delivery information associated with a export.
 * @property destination Has destination for the export being delivered.
 */
public data class ExportDeliveryInfoArgs(
    public val destination: Output<ExportDeliveryDestinationArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ExportDeliveryInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ExportDeliveryInfoArgs =
        com.pulumi.azurenative.costmanagement.inputs.ExportDeliveryInfoArgs.builder()
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExportDeliveryInfoArgs].
 */
@PulumiTagMarker
public class ExportDeliveryInfoArgsBuilder internal constructor() {
    private var destination: Output<ExportDeliveryDestinationArgs>? = null

    /**
     * @param value Has destination for the export being delivered.
     */
    @JvmName("ciufwlxnphumemmk")
    public suspend fun destination(`value`: Output<ExportDeliveryDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Has destination for the export being delivered.
     */
    @JvmName("frcxmaxhduqatcxq")
    public suspend fun destination(`value`: ExportDeliveryDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Has destination for the export being delivered.
     */
    @JvmName("ewufvibnfgqoedhc")
    public suspend
    fun destination(argument: suspend ExportDeliveryDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ExportDeliveryDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    internal fun build(): ExportDeliveryInfoArgs = ExportDeliveryInfoArgs(
        destination = destination ?: throw PulumiNullFieldException("destination"),
    )
}
