@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetCloudConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectorName Connector Name.
 * @property expand May be used to expand the collectionInfo property. By default, collectionInfo is not included.
 */
public data class GetCloudConnectorPlainArgs(
    public val connectorName: String,
    public val expand: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetCloudConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetCloudConnectorPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetCloudConnectorPlainArgs.builder()
            .connectorName(connectorName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetCloudConnectorPlainArgsBuilder internal constructor() {
    private var connectorName: String? = null

    private var expand: String? = null

    /**
     * @param value Connector Name.
     */
    @JvmName("kcxvbvluvgdcdise")
    public suspend fun connectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectorName = mapped
    }

    /**
     * @param value May be used to expand the collectionInfo property. By default, collectionInfo is not included.
     */
    @JvmName("fyoicwrqooklrcdc")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    internal fun build(): GetCloudConnectorPlainArgs = GetCloudConnectorPlainArgs(
        connectorName = connectorName ?: throw PulumiNullFieldException("connectorName"),
        expand = expand,
    )
}
