@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetExportPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand May be used to expand the properties within an export. Currently only 'runHistory' is supported and will return information for the last 10 runs of the export.
 * @property exportName Export Name.
 * @property scope The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope, and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
 */
public data class GetExportPlainArgs(
    public val expand: String? = null,
    public val exportName: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetExportPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetExportPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetExportPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .exportName(exportName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExportPlainArgs].
 */
@PulumiTagMarker
public class GetExportPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var exportName: String? = null

    private var scope: String? = null

    /**
     * @param value May be used to expand the properties within an export. Currently only 'runHistory' is supported and will return information for the last 10 runs of the export.
     */
    @JvmName("kmwwugqmycxdrked")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Export Name.
     */
    @JvmName("ceutkgmgxktxassg")
    public suspend fun exportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.exportName = mapped
    }

    /**
     * @param value The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope, and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
     */
    @JvmName("xlluyicgtliugorm")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetExportPlainArgs = GetExportPlainArgs(
        expand = expand,
        exportName = exportName ?: throw PulumiNullFieldException("exportName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
