@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property settingName Name of the setting. Allowed values: myscope
 */
public data class GetSettingPlainArgs(
    public val settingName: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetSettingPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetSettingPlainArgs.builder()
            .settingName(settingName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSettingPlainArgs].
 */
@PulumiTagMarker
public class GetSettingPlainArgsBuilder internal constructor() {
    private var settingName: String? = null

    /**
     * @param value Name of the setting. Allowed values: myscope
     */
    @JvmName("rjjiqobpquidwhss")
    public suspend fun settingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.settingName = mapped
    }

    internal fun build(): GetSettingPlainArgs = GetSettingPlainArgs(
        settingName = settingName ?: throw PulumiNullFieldException("settingName"),
    )
}
