@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetTagInheritanceSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scope The scope associated with this setting. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billing profile scope.
 * @property type Setting type.
 */
public data class GetTagInheritanceSettingPlainArgs(
    public val scope: String,
    public val type: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetTagInheritanceSettingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.costmanagement.inputs.GetTagInheritanceSettingPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetTagInheritanceSettingPlainArgs.builder()
            .scope(scope.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagInheritanceSettingPlainArgs].
 */
@PulumiTagMarker
public class GetTagInheritanceSettingPlainArgsBuilder internal constructor() {
    private var scope: String? = null

    private var type: String? = null

    /**
     * @param value The scope associated with this setting. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billing profile scope.
     */
    @JvmName("autlouisuwbdkgpa")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    /**
     * @param value Setting type.
     */
    @JvmName("spvajaglgeofvpse")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetTagInheritanceSettingPlainArgs = GetTagInheritanceSettingPlainArgs(
        scope = scope ?: throw PulumiNullFieldException("scope"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
