@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetViewByScopePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scope The scope associated with view operations. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, 'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account scope and 'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
 * @property viewName View name
 */
public data class GetViewByScopePlainArgs(
    public val scope: String,
    public val viewName: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetViewByScopePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetViewByScopePlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetViewByScopePlainArgs.builder()
            .scope(scope.let({ args0 -> args0 }))
            .viewName(viewName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetViewByScopePlainArgs].
 */
@PulumiTagMarker
public class GetViewByScopePlainArgsBuilder internal constructor() {
    private var scope: String? = null

    private var viewName: String? = null

    /**
     * @param value The scope associated with view operations. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, 'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account scope and 'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
     */
    @JvmName("ikcwedywthvkfufs")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    /**
     * @param value View name
     */
    @JvmName("cwibowtvgvnfouys")
    public suspend fun viewName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.viewName = mapped
    }

    internal fun build(): GetViewByScopePlainArgs = GetViewByScopePlainArgs(
        scope = scope ?: throw PulumiNullFieldException("scope"),
        viewName = viewName ?: throw PulumiNullFieldException("viewName"),
    )
}
