@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetViewPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property viewName View name
 */
public data class GetViewPlainArgs(
    public val viewName: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetViewPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetViewPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetViewPlainArgs.builder()
            .viewName(viewName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetViewPlainArgs].
 */
@PulumiTagMarker
public class GetViewPlainArgsBuilder internal constructor() {
    private var viewName: String? = null

    /**
     * @param value View name
     */
    @JvmName("ujgerwpjnklqlrgs")
    public suspend fun viewName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.viewName = mapped
    }

    internal fun build(): GetViewPlainArgs = GetViewPlainArgs(
        viewName = viewName ?: throw PulumiNullFieldException("viewName"),
    )
}
