@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportComparisonExpressionArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.OperatorType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The comparison expression to be used in the report.
 * @property name The name of the column to use in comparison.
 * @property operator The operator to use for comparison.
 * @property values Array of values to use for comparison
 */
public data class ReportComparisonExpressionArgs(
    public val name: Output<String>,
    public val `operator`: Output<Either<String, OperatorType>>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportComparisonExpressionArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportComparisonExpressionArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportComparisonExpressionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ReportComparisonExpressionArgs].
 */
@PulumiTagMarker
public class ReportComparisonExpressionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `operator`: Output<Either<String, OperatorType>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The name of the column to use in comparison.
     */
    @JvmName("oqhetldymwrhgyti")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The operator to use for comparison.
     */
    @JvmName("cpoompdcunurmngg")
    public suspend fun `operator`(`value`: Output<Either<String, OperatorType>>) {
        this.`operator` = value
    }

    /**
     * @param value Array of values to use for comparison
     */
    @JvmName("uunnbprvouvxxfij")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("yhuwvvjiokkhncrh")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Array of values to use for comparison
     */
    @JvmName("llyajkpjcholcduq")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The name of the column to use in comparison.
     */
    @JvmName("kcjofpqhxqukflhu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The operator to use for comparison.
     */
    @JvmName("dxaqeqejoicbrpse")
    public suspend fun `operator`(`value`: Either<String, OperatorType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The operator to use for comparison.
     */
    @JvmName("kwwmftlpbmjuuoql")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The operator to use for comparison.
     */
    @JvmName("xhcgjbhopmjkubfu")
    public fun `operator`(`value`: OperatorType) {
        val toBeMapped = Either.ofRight<String, OperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Array of values to use for comparison
     */
    @JvmName("arreaqrxblsslyoy")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Array of values to use for comparison
     */
    @JvmName("axeucutowgsfrift")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ReportComparisonExpressionArgs = ReportComparisonExpressionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
