@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The filter expression to be used in the report.
 * @property and The logical "AND" expression. Must have at least 2 items.
 * @property dimension Has comparison expression for a dimension
 * @property not The logical "NOT" expression.
 * @property or The logical "OR" expression. Must have at least 2 items.
 * @property tag Has comparison expression for a tag
 */
public data class ReportFilterArgs(
    public val and: Output<List<ReportFilterArgs>>? = null,
    public val dimension: Output<ReportComparisonExpressionArgs>? = null,
    public val not: Output<ReportFilterArgs>? = null,
    public val or: Output<List<ReportFilterArgs>>? = null,
    public val tag: Output<ReportComparisonExpressionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportFilterArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportFilterArgs.builder()
            .and(and?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .not(not?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .or(or?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tag(tag?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ReportFilterArgs].
 */
@PulumiTagMarker
public class ReportFilterArgsBuilder internal constructor() {
    private var and: Output<List<ReportFilterArgs>>? = null

    private var dimension: Output<ReportComparisonExpressionArgs>? = null

    private var not: Output<ReportFilterArgs>? = null

    private var or: Output<List<ReportFilterArgs>>? = null

    private var tag: Output<ReportComparisonExpressionArgs>? = null

    /**
     * @param value The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("gilvmxblobngiqwy")
    public suspend fun and(`value`: Output<List<ReportFilterArgs>>) {
        this.and = value
    }

    @JvmName("xcmnvioiwgqrvntx")
    public suspend fun and(vararg values: Output<ReportFilterArgs>) {
        this.and = Output.all(values.asList())
    }

    /**
     * @param values The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("qeyyhqevujakdvvi")
    public suspend fun and(values: List<Output<ReportFilterArgs>>) {
        this.and = Output.all(values)
    }

    /**
     * @param value Has comparison expression for a dimension
     */
    @JvmName("losjnvagwdtyojco")
    public suspend fun dimension(`value`: Output<ReportComparisonExpressionArgs>) {
        this.dimension = value
    }

    /**
     * @param value The logical "NOT" expression.
     */
    @JvmName("ujmliptaygbeuthe")
    public suspend fun not(`value`: Output<ReportFilterArgs>) {
        this.not = value
    }

    /**
     * @param value The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("ibhwejhpynmnrjdg")
    public suspend fun or(`value`: Output<List<ReportFilterArgs>>) {
        this.or = value
    }

    @JvmName("eiuemcfnhjmnnixe")
    public suspend fun or(vararg values: Output<ReportFilterArgs>) {
        this.or = Output.all(values.asList())
    }

    /**
     * @param values The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("wlfpsjckaldrvjwp")
    public suspend fun or(values: List<Output<ReportFilterArgs>>) {
        this.or = Output.all(values)
    }

    /**
     * @param value Has comparison expression for a tag
     */
    @JvmName("adcsmbwsyfrngecf")
    public suspend fun tag(`value`: Output<ReportComparisonExpressionArgs>) {
        this.tag = value
    }

    /**
     * @param value The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("okhmhvmvnoxncbyd")
    public suspend fun and(`value`: List<ReportFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("eypdqjtqdhfqtjdh")
    public suspend fun and(argument: List<suspend ReportFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReportFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("hlxmehosxkophbof")
    public suspend fun and(vararg argument: suspend ReportFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReportFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("oaroieywvytnbkvr")
    public suspend fun and(argument: suspend ReportFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReportFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param values The logical "AND" expression. Must have at least 2 items.
     */
    @JvmName("miicnhhbihlxobwl")
    public suspend fun and(vararg values: ReportFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.and = mapped
    }

    /**
     * @param value Has comparison expression for a dimension
     */
    @JvmName("wrkjxlfwollevrdw")
    public suspend fun dimension(`value`: ReportComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Has comparison expression for a dimension
     */
    @JvmName("efyqdaqtjstptkaw")
    public suspend fun dimension(argument: suspend ReportComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = ReportComparisonExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value The logical "NOT" expression.
     */
    @JvmName("pueswowrscraeowi")
    public suspend fun not(`value`: ReportFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.not = mapped
    }

    /**
     * @param argument The logical "NOT" expression.
     */
    @JvmName("rqtalqwyvjfjkobx")
    public suspend fun not(argument: suspend ReportFilterArgsBuilder.() -> Unit) {
        val toBeMapped = ReportFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.not = mapped
    }

    /**
     * @param value The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("wxjgejmsdxirxfye")
    public suspend fun or(`value`: List<ReportFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.or = mapped
    }

    /**
     * @param argument The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("grfravuxonihvatl")
    public suspend fun or(argument: List<suspend ReportFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReportFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.or = mapped
    }

    /**
     * @param argument The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("pdxkeertlioqhpqh")
    public suspend fun or(vararg argument: suspend ReportFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReportFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.or = mapped
    }

    /**
     * @param argument The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("pykfsarcctnsinud")
    public suspend fun or(argument: suspend ReportFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReportFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.or = mapped
    }

    /**
     * @param values The logical "OR" expression. Must have at least 2 items.
     */
    @JvmName("uiygrecrewyopgao")
    public suspend fun or(vararg values: ReportFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.or = mapped
    }

    /**
     * @param value Has comparison expression for a tag
     */
    @JvmName("llomcwprccqgoelo")
    public suspend fun tag(`value`: ReportComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param argument Has comparison expression for a tag
     */
    @JvmName("kqewbysgsdtjqafl")
    public suspend fun tag(argument: suspend ReportComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = ReportComparisonExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tag = mapped
    }

    internal fun build(): ReportFilterArgs = ReportFilterArgs(
        and = and,
        dimension = dimension,
        not = not,
        or = or,
        tag = tag,
    )
}
