@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportRecurrencePeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The start and end date for recurrence schedule.
 * @property from The start date of recurrence.
 * @property to The end date of recurrence.
 */
public data class ReportRecurrencePeriodArgs(
    public val from: Output<String>,
    public val to: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportRecurrencePeriodArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportRecurrencePeriodArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportRecurrencePeriodArgs.builder()
            .from(from.applyValue({ args0 -> args0 }))
            .to(to?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportRecurrencePeriodArgs].
 */
@PulumiTagMarker
public class ReportRecurrencePeriodArgsBuilder internal constructor() {
    private var from: Output<String>? = null

    private var to: Output<String>? = null

    /**
     * @param value The start date of recurrence.
     */
    @JvmName("egdeqovjeloijswl")
    public suspend fun from(`value`: Output<String>) {
        this.from = value
    }

    /**
     * @param value The end date of recurrence.
     */
    @JvmName("tfvcmuqjqrqnoxtk")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value The start date of recurrence.
     */
    @JvmName("uihbhtrvesjxbnvc")
    public suspend fun from(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.from = mapped
    }

    /**
     * @param value The end date of recurrence.
     */
    @JvmName("ghwwxcxddsxdhdsi")
    public suspend fun to(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): ReportRecurrencePeriodArgs = ReportRecurrencePeriodArgs(
        from = from ?: throw PulumiNullFieldException("from"),
        to = to,
    )
}
