@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportScheduleArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.RecurrenceType
import com.pulumi.azurenative.costmanagement.kotlin.enums.StatusType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The schedule associated with a report.
 * @property recurrence The schedule recurrence.
 * @property recurrencePeriod Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
 * @property status The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
 */
public data class ReportScheduleArgs(
    public val recurrence: Output<Either<String, RecurrenceType>>,
    public val recurrencePeriod: Output<ReportRecurrencePeriodArgs>? = null,
    public val status: Output<Either<String, StatusType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportScheduleArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportScheduleArgs.builder()
            .recurrence(
                recurrence.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .recurrencePeriod(recurrencePeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReportScheduleArgs].
 */
@PulumiTagMarker
public class ReportScheduleArgsBuilder internal constructor() {
    private var recurrence: Output<Either<String, RecurrenceType>>? = null

    private var recurrencePeriod: Output<ReportRecurrencePeriodArgs>? = null

    private var status: Output<Either<String, StatusType>>? = null

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("ysjeiyejwegwpfks")
    public suspend fun recurrence(`value`: Output<Either<String, RecurrenceType>>) {
        this.recurrence = value
    }

    /**
     * @param value Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
     */
    @JvmName("vvbyukdkftiqwkqk")
    public suspend fun recurrencePeriod(`value`: Output<ReportRecurrencePeriodArgs>) {
        this.recurrencePeriod = value
    }

    /**
     * @param value The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
     */
    @JvmName("byulxfyvywriqspw")
    public suspend fun status(`value`: Output<Either<String, StatusType>>) {
        this.status = value
    }

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("rydetinucraiiijm")
    public suspend fun recurrence(`value`: Either<String, RecurrenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("evgbixuyiknuaucc")
    public fun recurrence(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecurrenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("gvjvsbvlpketqjnm")
    public fun recurrence(`value`: RecurrenceType) {
        val toBeMapped = Either.ofRight<String, RecurrenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param value Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
     */
    @JvmName("ktxlyovgnysnsngv")
    public suspend fun recurrencePeriod(`value`: ReportRecurrencePeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrencePeriod = mapped
    }

    /**
     * @param argument Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
     */
    @JvmName("xxxrkkbqirtqlxlb")
    public suspend
    fun recurrencePeriod(argument: suspend ReportRecurrencePeriodArgsBuilder.() -> Unit) {
        val toBeMapped = ReportRecurrencePeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrencePeriod = mapped
    }

    /**
     * @param value The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
     */
    @JvmName("agunhwmpjtrapoyu")
    public suspend fun status(`value`: Either<String, StatusType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
     */
    @JvmName("buqusjrksqndcubt")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StatusType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
     */
    @JvmName("atedjvphqlvsmymd")
    public fun status(`value`: StatusType) {
        val toBeMapped = Either.ofRight<String, StatusType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ReportScheduleArgs = ReportScheduleArgs(
        recurrence = recurrence ?: throw PulumiNullFieldException("recurrence"),
        recurrencePeriod = recurrencePeriod,
        status = status,
    )
}
