@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.SourceCostAllocationResourceArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.CostAllocationResourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Source resources for cost allocation
 * @property name If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
 * @property resourceType Type of resources contained in this cost allocation rule
 * @property values Source Resources for cost allocation. This list cannot contain more than 25 values.
 */
public data class SourceCostAllocationResourceArgs(
    public val name: Output<String>,
    public val resourceType: Output<Either<String, CostAllocationResourceType>>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.SourceCostAllocationResourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.costmanagement.inputs.SourceCostAllocationResourceArgs =
        com.pulumi.azurenative.costmanagement.inputs.SourceCostAllocationResourceArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .resourceType(
                resourceType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SourceCostAllocationResourceArgs].
 */
@PulumiTagMarker
public class SourceCostAllocationResourceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var resourceType: Output<Either<String, CostAllocationResourceType>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
     */
    @JvmName("alnwpkikhovntrqy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of resources contained in this cost allocation rule
     */
    @JvmName("opjvrditiffvyvmr")
    public suspend fun resourceType(`value`: Output<Either<String, CostAllocationResourceType>>) {
        this.resourceType = value
    }

    /**
     * @param value Source Resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("vuegibareslhjmjd")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("huhlqkxjwqxakbow")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Source Resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("nydnfqcctgnxcasn")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
     */
    @JvmName("xilsityppqgmohbr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of resources contained in this cost allocation rule
     */
    @JvmName("qdjgerrsvfcjghsi")
    public suspend fun resourceType(`value`: Either<String, CostAllocationResourceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Type of resources contained in this cost allocation rule
     */
    @JvmName("ofjawweirufscmog")
    public fun resourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CostAllocationResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Type of resources contained in this cost allocation rule
     */
    @JvmName("euwjcopqprywnppl")
    public fun resourceType(`value`: CostAllocationResourceType) {
        val toBeMapped = Either.ofRight<String, CostAllocationResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Source Resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("nfqkhceuxrxsmhvv")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Source Resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("rkdtrsqlqsdylypj")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): SourceCostAllocationResourceArgs = SourceCostAllocationResourceArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
