@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.TagInheritancePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the tag inheritance setting.
 * @property preferContainerTags When resource has the same tag as subscription or resource group and this property is set to true - the subscription or resource group tag will be applied. If subscription and resource group tags are also the same, subscription tag will be applied.
 */
public data class TagInheritancePropertiesArgs(
    public val preferContainerTags: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.TagInheritancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.TagInheritancePropertiesArgs =
        com.pulumi.azurenative.costmanagement.inputs.TagInheritancePropertiesArgs.builder()
            .preferContainerTags(preferContainerTags.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagInheritancePropertiesArgs].
 */
@PulumiTagMarker
public class TagInheritancePropertiesArgsBuilder internal constructor() {
    private var preferContainerTags: Output<Boolean>? = null

    /**
     * @param value When resource has the same tag as subscription or resource group and this property is set to true - the subscription or resource group tag will be applied. If subscription and resource group tags are also the same, subscription tag will be applied.
     */
    @JvmName("kxbssjiijqyjyrqv")
    public suspend fun preferContainerTags(`value`: Output<Boolean>) {
        this.preferContainerTags = value
    }

    /**
     * @param value When resource has the same tag as subscription or resource group and this property is set to true - the subscription or resource group tag will be applied. If subscription and resource group tags are also the same, subscription tag will be applied.
     */
    @JvmName("rchbokwctspxunxb")
    public suspend fun preferContainerTags(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferContainerTags = mapped
    }

    internal fun build(): TagInheritancePropertiesArgs = TagInheritancePropertiesArgs(
        preferContainerTags = preferContainerTags ?: throw PulumiNullFieldException("preferContainerTags"),
    )
}
