@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Resource details of the cost allocation rule
 * @property sourceResources Source resources for cost allocation. At this time, this list can contain no more than one element.
 * @property targetResources Target resources for cost allocation. At this time, this list can contain no more than one element.
 */
public data class CostAllocationRuleDetailsResponse(
    public val sourceResources: List<SourceCostAllocationResourceResponse>? = null,
    public val targetResources: List<TargetCostAllocationResourceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.CostAllocationRuleDetailsResponse):
            CostAllocationRuleDetailsResponse = CostAllocationRuleDetailsResponse(
            sourceResources = javaType.sourceResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.SourceCostAllocationResourceResponse.Companion.toKotlin(args0)
                })
            }),
            targetResources = javaType.targetResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.TargetCostAllocationResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
