@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An export resource.
 * @property definition Has the definition for the export.
 * @property deliveryInfo Has delivery information for the export.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property format The format of the export being delivered. Currently only 'Csv' is supported.
 * @property id Resource Id.
 * @property name Resource name.
 * @property nextRunTimeEstimate If the export has an active schedule, provides an estimate of the next run time.
 * @property partitionData If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for Microsoft Customer Agreement commerce scopes.
 * @property runHistory If requested, has the most recent run history for the export.
 * @property schedule Has schedule information for the export.
 * @property type Resource type.
 */
public data class GetExportResult(
    public val definition: ExportDefinitionResponse,
    public val deliveryInfo: ExportDeliveryInfoResponse,
    public val eTag: String? = null,
    public val format: String? = null,
    public val id: String,
    public val name: String,
    public val nextRunTimeEstimate: String,
    public val partitionData: Boolean? = null,
    public val runHistory: ExportExecutionListResultResponse? = null,
    public val schedule: ExportScheduleResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetExportResult):
            GetExportResult = GetExportResult(
            definition = javaType.definition().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportDefinitionResponse.Companion.toKotlin(args0)
            }),
            deliveryInfo = javaType.deliveryInfo().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportDeliveryInfoResponse.Companion.toKotlin(args0)
            }),
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            nextRunTimeEstimate = javaType.nextRunTimeEstimate(),
            partitionData = javaType.partitionData().map({ args0 -> args0 }).orElse(null),
            runHistory = javaType.runHistory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportExecutionListResultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
