@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * States and configurations of Cost Analysis.
 * @property accumulated Show costs accumulated over time.
 * @property chart Chart type of the main view in Cost Analysis. Required.
 * @property createdOn Date the user created this view.
 * @property currency Currency of the current view.
 * @property dataSet Has definition for data in this report config.
 * @property dateRange Date range of the current view.
 * @property displayName User input name of the view. Required.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property id Resource Id.
 * @property includeMonetaryCommitment If true, report includes monetary commitment.
 * @property kpis List of KPIs to show in Cost Analysis UI.
 * @property metric Metric to use when displaying costs.
 * @property modifiedOn Date when the user last modified this view.
 * @property name Resource name.
 * @property pivots Configuration of 3 sub-views in the Cost Analysis UI.
 * @property scope Cost Management scope to save the view on. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
 * @property timePeriod Has time period for pulling data for the report.
 * @property timeframe The time frame for pulling data for the report. If custom, then a specific time period must be provided.
 * @property type Resource type.
 */
public data class GetViewByScopeResult(
    public val accumulated: String? = null,
    public val chart: String? = null,
    public val createdOn: String,
    public val currency: String,
    public val dataSet: ReportConfigDatasetResponse? = null,
    public val dateRange: String? = null,
    public val displayName: String? = null,
    public val eTag: String? = null,
    public val id: String,
    public val includeMonetaryCommitment: Boolean? = null,
    public val kpis: List<KpiPropertiesResponse>? = null,
    public val metric: String? = null,
    public val modifiedOn: String? = null,
    public val name: String,
    public val pivots: List<PivotPropertiesResponse>? = null,
    public val scope: String? = null,
    public val timePeriod: ReportConfigTimePeriodResponse? = null,
    public val timeframe: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetViewByScopeResult):
            GetViewByScopeResult = GetViewByScopeResult(
            accumulated = javaType.accumulated().map({ args0 -> args0 }).orElse(null),
            chart = javaType.chart().map({ args0 -> args0 }).orElse(null),
            createdOn = javaType.createdOn(),
            currency = javaType.currency(),
            dataSet = javaType.dataSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigDatasetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dateRange = javaType.dateRange().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            includeMonetaryCommitment = javaType.includeMonetaryCommitment().map({ args0 ->
                args0
            }).orElse(null),
            kpis = javaType.kpis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.KpiPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            metric = javaType.metric().map({ args0 -> args0 }).orElse(null),
            modifiedOn = javaType.modifiedOn().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            pivots = javaType.pivots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.PivotPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            timePeriod = javaType.timePeriod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigTimePeriodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeframe = javaType.timeframe(),
            type = javaType.type(),
        )
    }
}
