@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Source resources for cost allocation
 * @property name If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
 * @property resourceType Type of resources contained in this cost allocation rule
 * @property values Source Resources for cost allocation. This list cannot contain more than 25 values.
 */
public data class SourceCostAllocationResourceResponse(
    public val name: String,
    public val resourceType: String,
    public val values: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.SourceCostAllocationResourceResponse):
            SourceCostAllocationResourceResponse = SourceCostAllocationResourceResponse(
            name = javaType.name(),
            resourceType = javaType.resourceType(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
