@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.ConnectorMappingArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.ConnectorTypes
import com.pulumi.azurenative.customerinsights.kotlin.enums.EntityTypes
import com.pulumi.azurenative.customerinsights.kotlin.inputs.ConnectorMappingPropertiesArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.ConnectorMappingPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The connector mapping resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### ConnectorMappings_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectorMapping = new AzureNative.CustomerInsights.ConnectorMapping("connectorMapping", new()
 *     {
 *         ConnectorName = "testConnector8858",
 *         Description = "Test mapping",
 *         DisplayName = "testMapping12491",
 *         EntityType = AzureNative.CustomerInsights.EntityTypes.Interaction,
 *         EntityTypeName = "TestInteractionType2967",
 *         HubName = "sdkTestHub",
 *         MappingName = "testMapping12491",
 *         MappingProperties = new AzureNative.CustomerInsights.Inputs.ConnectorMappingPropertiesArgs
 *         {
 *             Availability = new AzureNative.CustomerInsights.Inputs.ConnectorMappingAvailabilityArgs
 *             {
 *                 Frequency = AzureNative.CustomerInsights.FrequencyTypes.Hour,
 *                 Interval = 5,
 *             },
 *             CompleteOperation = new AzureNative.CustomerInsights.Inputs.ConnectorMappingCompleteOperationArgs
 *             {
 *                 CompletionOperationType = AzureNative.CustomerInsights.CompletionOperationTypes.DeleteFile,
 *                 DestinationFolder = "fakePath",
 *             },
 *             ErrorManagement = new AzureNative.CustomerInsights.Inputs.ConnectorMappingErrorManagementArgs
 *             {
 *                 ErrorLimit = 10,
 *                 ErrorManagementType = AzureNative.CustomerInsights.ErrorManagementTypes.StopImport,
 *             },
 *             FileFilter = "unknown",
 *             FolderPath = "http://sample.dne/file",
 *             Format = new AzureNative.CustomerInsights.Inputs.ConnectorMappingFormatArgs
 *             {
 *                 ColumnDelimiter = "|",
 *                 FormatType = AzureNative.CustomerInsights.FormatTypes.TextFormat,
 *             },
 *             HasHeader = false,
 *             Structure = new[]
 *             {
 *                 new AzureNative.CustomerInsights.Inputs.ConnectorMappingStructureArgs
 *                 {
 *                     ColumnName = "unknown1",
 *                     IsEncrypted = false,
 *                     PropertyName = "unknwon1",
 *                 },
 *                 new AzureNative.CustomerInsights.Inputs.ConnectorMappingStructureArgs
 *                 {
 *                     ColumnName = "unknown2",
 *                     IsEncrypted = true,
 *                     PropertyName = "unknwon2",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewConnectorMapping(ctx, "connectorMapping", &customerinsights.ConnectorMappingArgs{
 * 			ConnectorName:  pulumi.String("testConnector8858"),
 * 			Description:    pulumi.String("Test mapping"),
 * 			DisplayName:    pulumi.String("testMapping12491"),
 * 			EntityType:     customerinsights.EntityTypesInteraction,
 * 			EntityTypeName: pulumi.String("TestInteractionType2967"),
 * 			HubName:        pulumi.String("sdkTestHub"),
 * 			MappingName:    pulumi.String("testMapping12491"),
 * 			MappingProperties: customerinsights.ConnectorMappingPropertiesResponse{
 * 				Availability: &customerinsights.ConnectorMappingAvailabilityArgs{
 * 					Frequency: customerinsights.FrequencyTypesHour,
 * 					Interval:  pulumi.Int(5),
 * 				},
 * 				CompleteOperation: &customerinsights.ConnectorMappingCompleteOperationArgs{
 * 					CompletionOperationType: customerinsights.CompletionOperationTypesDeleteFile,
 * 					DestinationFolder:       pulumi.String("fakePath"),
 * 				},
 * 				ErrorManagement: &customerinsights.ConnectorMappingErrorManagementArgs{
 * 					ErrorLimit:          pulumi.Int(10),
 * 					ErrorManagementType: customerinsights.ErrorManagementTypesStopImport,
 * 				},
 * 				FileFilter: pulumi.String("unknown"),
 * 				FolderPath: pulumi.String("http://sample.dne/file"),
 * 				Format: &customerinsights.ConnectorMappingFormatArgs{
 * 					ColumnDelimiter: pulumi.String("|"),
 * 					FormatType:      customerinsights.FormatTypesTextFormat,
 * 				},
 * 				HasHeader: pulumi.Bool(false),
 * 				Structure: customerinsights.ConnectorMappingStructureArray{
 * 					&customerinsights.ConnectorMappingStructureArgs{
 * 						ColumnName:   pulumi.String("unknown1"),
 * 						IsEncrypted:  pulumi.Bool(false),
 * 						PropertyName: pulumi.String("unknwon1"),
 * 					},
 * 					&customerinsights.ConnectorMappingStructureArgs{
 * 						ColumnName:   pulumi.String("unknown2"),
 * 						IsEncrypted:  pulumi.Bool(true),
 * 						PropertyName: pulumi.String("unknwon2"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.ConnectorMapping;
 * import com.pulumi.azurenative.customerinsights.ConnectorMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectorMapping = new ConnectorMapping("connectorMapping", ConnectorMappingArgs.builder()
 *             .connectorName("testConnector8858")
 *             .description("Test mapping")
 *             .displayName("testMapping12491")
 *             .entityType("Interaction")
 *             .entityTypeName("TestInteractionType2967")
 *             .hubName("sdkTestHub")
 *             .mappingName("testMapping12491")
 *             .mappingProperties(Map.ofEntries(
 *                 Map.entry("availability", Map.ofEntries(
 *                     Map.entry("frequency", "Hour"),
 *                     Map.entry("interval", 5)
 *                 )),
 *                 Map.entry("completeOperation", Map.ofEntries(
 *                     Map.entry("completionOperationType", "DeleteFile"),
 *                     Map.entry("destinationFolder", "fakePath")
 *                 )),
 *                 Map.entry("errorManagement", Map.ofEntries(
 *                     Map.entry("errorLimit", 10),
 *                     Map.entry("errorManagementType", "StopImport")
 *                 )),
 *                 Map.entry("fileFilter", "unknown"),
 *                 Map.entry("folderPath", "http://sample.dne/file"),
 *                 Map.entry("format", Map.ofEntries(
 *                     Map.entry("columnDelimiter", "|"),
 *                     Map.entry("formatType", "TextFormat")
 *                 )),
 *                 Map.entry("hasHeader", false),
 *                 Map.entry("structure",
 *                     Map.ofEntries(
 *                         Map.entry("columnName", "unknown1"),
 *                         Map.entry("isEncrypted", false),
 *                         Map.entry("propertyName", "unknwon1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("columnName", "unknown2"),
 *                         Map.entry("isEncrypted", true),
 *                         Map.entry("propertyName", "unknwon2")
 *                     ))
 *             ))
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:ConnectorMapping sdkTestHub/testConnector8858/testMapping12491 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}/mappings/{mappingName}
 * ```
 * @property connectorName The name of the connector.
 * @property connectorType Type of connector.
 * @property description The description of the connector mapping.
 * @property displayName Display name for the connector mapping.
 * @property entityType Defines which entity type the file should map to.
 * @property entityTypeName The mapping entity name.
 * @property hubName The name of the hub.
 * @property mappingName The name of the connector mapping.
 * @property mappingProperties The properties of the mapping.
 * @property resourceGroupName The name of the resource group.
 */
public data class ConnectorMappingArgs(
    public val connectorName: Output<String>? = null,
    public val connectorType: Output<Either<String, ConnectorTypes>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val entityType: Output<EntityTypes>? = null,
    public val entityTypeName: Output<String>? = null,
    public val hubName: Output<String>? = null,
    public val mappingName: Output<String>? = null,
    public val mappingProperties: Output<ConnectorMappingPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.ConnectorMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.ConnectorMappingArgs =
        com.pulumi.azurenative.customerinsights.ConnectorMappingArgs.builder()
            .connectorName(connectorName?.applyValue({ args0 -> args0 }))
            .connectorType(
                connectorType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .entityType(entityType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .entityTypeName(entityTypeName?.applyValue({ args0 -> args0 }))
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .mappingName(mappingName?.applyValue({ args0 -> args0 }))
            .mappingProperties(mappingProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorMappingArgs].
 */
@PulumiTagMarker
public class ConnectorMappingArgsBuilder internal constructor() {
    private var connectorName: Output<String>? = null

    private var connectorType: Output<Either<String, ConnectorTypes>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var entityType: Output<EntityTypes>? = null

    private var entityTypeName: Output<String>? = null

    private var hubName: Output<String>? = null

    private var mappingName: Output<String>? = null

    private var mappingProperties: Output<ConnectorMappingPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the connector.
     */
    @JvmName("etukuexdwlhysfge")
    public suspend fun connectorName(`value`: Output<String>) {
        this.connectorName = value
    }

    /**
     * @param value Type of connector.
     */
    @JvmName("pnlsbfaigwofbusg")
    public suspend fun connectorType(`value`: Output<Either<String, ConnectorTypes>>) {
        this.connectorType = value
    }

    /**
     * @param value The description of the connector mapping.
     */
    @JvmName("regjkmdshtvlfkjp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name for the connector mapping.
     */
    @JvmName("yjvtuyvphbctdaed")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Defines which entity type the file should map to.
     */
    @JvmName("wrjtxmrtbnyxyhwu")
    public suspend fun entityType(`value`: Output<EntityTypes>) {
        this.entityType = value
    }

    /**
     * @param value The mapping entity name.
     */
    @JvmName("fswudmlqylskyujj")
    public suspend fun entityTypeName(`value`: Output<String>) {
        this.entityTypeName = value
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("dpucamjynqlaepxb")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value The name of the connector mapping.
     */
    @JvmName("adpsefxpuoxsyrua")
    public suspend fun mappingName(`value`: Output<String>) {
        this.mappingName = value
    }

    /**
     * @param value The properties of the mapping.
     */
    @JvmName("pkhcqrjcjlxsuixg")
    public suspend fun mappingProperties(`value`: Output<ConnectorMappingPropertiesArgs>) {
        this.mappingProperties = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ttuyvrivxudchdee")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the connector.
     */
    @JvmName("tgcaioqulatnhtxb")
    public suspend fun connectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorName = mapped
    }

    /**
     * @param value Type of connector.
     */
    @JvmName("rmvaymrevllqbcgm")
    public suspend fun connectorType(`value`: Either<String, ConnectorTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value Type of connector.
     */
    @JvmName("baeptuudknfppjmb")
    public fun connectorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectorTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value Type of connector.
     */
    @JvmName("dynxxumhuiyefipg")
    public fun connectorType(`value`: ConnectorTypes) {
        val toBeMapped = Either.ofRight<String, ConnectorTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorType = mapped
    }

    /**
     * @param value The description of the connector mapping.
     */
    @JvmName("yafjilwvqywrmcic")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name for the connector mapping.
     */
    @JvmName("qvungksfqgdbreie")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Defines which entity type the file should map to.
     */
    @JvmName("eeqbgxqxkdjouhlu")
    public suspend fun entityType(`value`: EntityTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityType = mapped
    }

    /**
     * @param value The mapping entity name.
     */
    @JvmName("apurbovkqxwhmray")
    public suspend fun entityTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityTypeName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("icxiewkwrtdkbsaf")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value The name of the connector mapping.
     */
    @JvmName("abwpdhdrywkomemb")
    public suspend fun mappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingName = mapped
    }

    /**
     * @param value The properties of the mapping.
     */
    @JvmName("nmelhotjungqalmq")
    public suspend fun mappingProperties(`value`: ConnectorMappingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingProperties = mapped
    }

    /**
     * @param argument The properties of the mapping.
     */
    @JvmName("xklfoadltkgbwnsq")
    public suspend
    fun mappingProperties(argument: suspend ConnectorMappingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorMappingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mappingProperties = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jpwjwhtvyoqswkrc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ConnectorMappingArgs = ConnectorMappingArgs(
        connectorName = connectorName,
        connectorType = connectorType,
        description = description,
        displayName = displayName,
        entityType = entityType,
        entityTypeName = entityTypeName,
        hubName = hubName,
        mappingName = mappingName,
        mappingProperties = mappingProperties,
        resourceGroupName = resourceGroupName,
    )
}
