@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiAliasResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiExtractResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiGroupByMetadataResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiParticipantProfilesMetadataResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiThresholdsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiAliasResponse.Companion.toKotlin as kpiAliasResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiExtractResponse.Companion.toKotlin as kpiExtractResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiGroupByMetadataResponse.Companion.toKotlin as kpiGroupByMetadataResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiParticipantProfilesMetadataResponse.Companion.toKotlin as kpiParticipantProfilesMetadataResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.KpiThresholdsResponse.Companion.toKotlin as kpiThresholdsResponseToKotlin

/**
 * Builder for [Kpi].
 */
@PulumiTagMarker
public class KpiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KpiArgs = KpiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KpiArgsBuilder.() -> Unit) {
        val builder = KpiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Kpi {
        val builtJavaResource = com.pulumi.azurenative.customerinsights.Kpi(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Kpi(builtJavaResource)
    }
}

/**
 * The KPI resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Kpi_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kpi = new AzureNative.CustomerInsights.Kpi("kpi", new()
 *     {
 *         Aliases = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.KpiAliasArgs
 *             {
 *                 AliasName = "alias",
 *                 Expression = "Id+4",
 *             },
 *         },
 *         CalculationWindow = AzureNative.CustomerInsights.CalculationWindowTypes.Day,
 *         Description =
 *         {
 *             { "en-us", "Kpi Description" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "Kpi DisplayName" },
 *         },
 *         EntityType = AzureNative.CustomerInsights.EntityTypes.Profile,
 *         EntityTypeName = "testProfile2327128",
 *         Expression = "SavingAccountBalance",
 *         Function = AzureNative.CustomerInsights.KpiFunctions.Sum,
 *         GroupBy = new[]
 *         {
 *             "SavingAccountBalance",
 *         },
 *         HubName = "sdkTestHub",
 *         KpiName = "kpiTest45453647",
 *         ResourceGroupName = "TestHubRG",
 *         ThresHolds = new AzureNative.CustomerInsights.Inputs.KpiThresholdsArgs
 *         {
 *             IncreasingKpi = true,
 *             LowerLimit = 5,
 *             UpperLimit = 50,
 *         },
 *         Unit = "unit",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewKpi(ctx, "kpi", &customerinsights.KpiArgs{
 * 			Aliases: []customerinsights.KpiAliasArgs{
 * 				{
 * 					AliasName:  pulumi.String("alias"),
 * 					Expression: pulumi.String("Id+4"),
 * 				},
 * 			},
 * 			CalculationWindow: customerinsights.CalculationWindowTypesDay,
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("Kpi Description"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("Kpi DisplayName"),
 * 			},
 * 			EntityType:     customerinsights.EntityTypesProfile,
 * 			EntityTypeName: pulumi.String("testProfile2327128"),
 * 			Expression:     pulumi.String("SavingAccountBalance"),
 * 			Function:       customerinsights.KpiFunctionsSum,
 * 			GroupBy: pulumi.StringArray{
 * 				pulumi.String("SavingAccountBalance"),
 * 			},
 * 			HubName:           pulumi.String("sdkTestHub"),
 * 			KpiName:           pulumi.String("kpiTest45453647"),
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 			ThresHolds: &customerinsights.KpiThresholdsArgs{
 * 				IncreasingKpi: pulumi.Bool(true),
 * 				LowerLimit:    pulumi.Float64(5),
 * 				UpperLimit:    pulumi.Float64(50),
 * 			},
 * 			Unit: pulumi.String("unit"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Kpi;
 * import com.pulumi.azurenative.customerinsights.KpiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kpi = new Kpi("kpi", KpiArgs.builder()
 *             .aliases(Map.ofEntries(
 *                 Map.entry("aliasName", "alias"),
 *                 Map.entry("expression", "Id+4")
 *             ))
 *             .calculationWindow("Day")
 *             .description(Map.of("en-us", "Kpi Description"))
 *             .displayName(Map.of("en-us", "Kpi DisplayName"))
 *             .entityType("Profile")
 *             .entityTypeName("testProfile2327128")
 *             .expression("SavingAccountBalance")
 *             .function("Sum")
 *             .groupBy("SavingAccountBalance")
 *             .hubName("sdkTestHub")
 *             .kpiName("kpiTest45453647")
 *             .resourceGroupName("TestHubRG")
 *             .thresHolds(Map.ofEntries(
 *                 Map.entry("increasingKpi", true),
 *                 Map.entry("lowerLimit", 5),
 *                 Map.entry("upperLimit", 50)
 *             ))
 *             .unit("unit")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Kpi sdkTestHub/kpiTest45453647 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}
 * ```
 */
public class Kpi internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.Kpi,
) : KotlinCustomResource(javaResource, KpiMapper) {
    /**
     * The aliases.
     */
    public val aliases: Output<List<KpiAliasResponse>>?
        get() = javaResource.aliases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> kpiAliasResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The calculation window.
     */
    public val calculationWindow: Output<String>
        get() = javaResource.calculationWindow().applyValue({ args0 -> args0 })

    /**
     * Name of calculation window field.
     */
    public val calculationWindowFieldName: Output<String>?
        get() = javaResource.calculationWindowFieldName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Localized description for the KPI.
     */
    public val description: Output<Map<String, String>>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Localized display name for the KPI.
     */
    public val displayName: Output<Map<String, String>>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The mapping entity type.
     */
    public val entityType: Output<String>
        get() = javaResource.entityType().applyValue({ args0 -> args0 })

    /**
     * The mapping entity name.
     */
    public val entityTypeName: Output<String>
        get() = javaResource.entityTypeName().applyValue({ args0 -> args0 })

    /**
     * The computation expression for the KPI.
     */
    public val expression: Output<String>
        get() = javaResource.expression().applyValue({ args0 -> args0 })

    /**
     * The KPI extracts.
     */
    public val extracts: Output<List<KpiExtractResponse>>?
        get() = javaResource.extracts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> kpiExtractResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The filter expression for the KPI.
     */
    public val filter: Output<String>?
        get() = javaResource.filter().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The computation function for the KPI.
     */
    public val function: Output<String>
        get() = javaResource.function().applyValue({ args0 -> args0 })

    /**
     * the group by properties for the KPI.
     */
    public val groupBy: Output<List<String>>?
        get() = javaResource.groupBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The KPI GroupByMetadata.
     */
    public val groupByMetadata: Output<List<KpiGroupByMetadataResponse>>
        get() = javaResource.groupByMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kpiGroupByMetadataResponseToKotlin(args0) })
            })
        })

    /**
     * The KPI name.
     */
    public val kpiName: Output<String>
        get() = javaResource.kpiName().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The participant profiles.
     */
    public val participantProfilesMetadata: Output<List<KpiParticipantProfilesMetadataResponse>>
        get() = javaResource.participantProfilesMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kpiParticipantProfilesMetadataResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * The KPI thresholds.
     */
    public val thresHolds: Output<KpiThresholdsResponse>?
        get() = javaResource.thresHolds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kpiThresholdsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unit of measurement for the KPI.
     */
    public val unit: Output<String>?
        get() = javaResource.unit().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object KpiMapper : ResourceMapper<Kpi> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.Kpi::class == javaResource::class

    override fun map(javaResource: Resource): Kpi = Kpi(
        javaResource as
            com.pulumi.azurenative.customerinsights.Kpi,
    )
}

/**
 * @see [Kpi].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Kpi].
 */
public suspend fun kpi(name: String, block: suspend KpiResourceBuilder.() -> Unit): Kpi {
    val builder = KpiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Kpi].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kpi(name: String): Kpi {
    val builder = KpiResourceBuilder()
    builder.name(name)
    return builder.build()
}
