@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.ParticipantPropertyReferenceResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.TypePropertiesMappingResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.customerinsights.kotlin.outputs.ParticipantPropertyReferenceResponse.Companion.toKotlin as participantPropertyReferenceResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.TypePropertiesMappingResponse.Companion.toKotlin as typePropertiesMappingResponseToKotlin

/**
 * Builder for [Link].
 */
@PulumiTagMarker
public class LinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkArgs = LinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkArgsBuilder.() -> Unit) {
        val builder = LinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Link {
        val builtJavaResource = com.pulumi.azurenative.customerinsights.Link(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Link(builtJavaResource)
    }
}

/**
 * The link resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * Other available API versions: 2017-01-01.
 * ## Example Usage
 * ### Links_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var link = new AzureNative.CustomerInsights.Link("link", new()
 *     {
 *         Description =
 *         {
 *             { "en-us", "Link Description" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "Link DisplayName" },
 *         },
 *         HubName = "sdkTestHub",
 *         LinkName = "linkTest4806",
 *         Mappings = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.TypePropertiesMappingArgs
 *             {
 *                 LinkType = AzureNative.CustomerInsights.LinkTypes.UpdateAlways,
 *                 SourcePropertyName = "testInteraction1949",
 *                 TargetPropertyName = "testProfile1446",
 *             },
 *         },
 *         ParticipantPropertyReferences = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.ParticipantPropertyReferenceArgs
 *             {
 *                 SourcePropertyName = "testInteraction1949",
 *                 TargetPropertyName = "ProfileId",
 *             },
 *         },
 *         ResourceGroupName = "TestHubRG",
 *         SourceEntityType = AzureNative.CustomerInsights.EntityType.Interaction,
 *         SourceEntityTypeName = "testInteraction1949",
 *         TargetEntityType = AzureNative.CustomerInsights.EntityType.Profile,
 *         TargetEntityTypeName = "testProfile1446",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewLink(ctx, "link", &customerinsights.LinkArgs{
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("Link Description"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("Link DisplayName"),
 * 			},
 * 			HubName:  pulumi.String("sdkTestHub"),
 * 			LinkName: pulumi.String("linkTest4806"),
 * 			Mappings: []customerinsights.TypePropertiesMappingArgs{
 * 				{
 * 					LinkType:           customerinsights.LinkTypesUpdateAlways,
 * 					SourcePropertyName: pulumi.String("testInteraction1949"),
 * 					TargetPropertyName: pulumi.String("testProfile1446"),
 * 				},
 * 			},
 * 			ParticipantPropertyReferences: []customerinsights.ParticipantPropertyReferenceArgs{
 * 				{
 * 					SourcePropertyName: pulumi.String("testInteraction1949"),
 * 					TargetPropertyName: pulumi.String("ProfileId"),
 * 				},
 * 			},
 * 			ResourceGroupName:    pulumi.String("TestHubRG"),
 * 			SourceEntityType:     customerinsights.EntityTypeInteraction,
 * 			SourceEntityTypeName: pulumi.String("testInteraction1949"),
 * 			TargetEntityType:     customerinsights.EntityTypeProfile,
 * 			TargetEntityTypeName: pulumi.String("testProfile1446"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Link;
 * import com.pulumi.azurenative.customerinsights.LinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var link = new Link("link", LinkArgs.builder()
 *             .description(Map.of("en-us", "Link Description"))
 *             .displayName(Map.of("en-us", "Link DisplayName"))
 *             .hubName("sdkTestHub")
 *             .linkName("linkTest4806")
 *             .mappings(Map.ofEntries(
 *                 Map.entry("linkType", "UpdateAlways"),
 *                 Map.entry("sourcePropertyName", "testInteraction1949"),
 *                 Map.entry("targetPropertyName", "testProfile1446")
 *             ))
 *             .participantPropertyReferences(Map.ofEntries(
 *                 Map.entry("sourcePropertyName", "testInteraction1949"),
 *                 Map.entry("targetPropertyName", "ProfileId")
 *             ))
 *             .resourceGroupName("TestHubRG")
 *             .sourceEntityType("Interaction")
 *             .sourceEntityTypeName("testInteraction1949")
 *             .targetEntityType("Profile")
 *             .targetEntityTypeName("testProfile1446")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Link azSdkTestHub/linkTest4806 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/links/{linkName}
 * ```
 */
public class Link internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.Link,
) : KotlinCustomResource(javaResource, LinkMapper) {
    /**
     * Localized descriptions for the Link.
     */
    public val description: Output<Map<String, String>>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Localized display name for the Link.
     */
    public val displayName: Output<Map<String, String>>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The link name.
     */
    public val linkName: Output<String>
        get() = javaResource.linkName().applyValue({ args0 -> args0 })

    /**
     * The set of properties mappings between the source and target Types.
     */
    public val mappings: Output<List<TypePropertiesMappingResponse>>?
        get() = javaResource.mappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> typePropertiesMappingResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only.
     */
    public val operationType: Output<String>?
        get() = javaResource.operationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The properties that represent the participating profile.
     */
    public val participantPropertyReferences: Output<List<ParticipantPropertyReferenceResponse>>
        get() = javaResource.participantPropertyReferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> participantPropertyReferenceResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are not defined and it is set to true, links processing will not create or update profiles.
     */
    public val referenceOnly: Output<Boolean>?
        get() = javaResource.referenceOnly().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of source entity.
     */
    public val sourceEntityType: Output<String>
        get() = javaResource.sourceEntityType().applyValue({ args0 -> args0 })

    /**
     * Name of the source Entity Type.
     */
    public val sourceEntityTypeName: Output<String>
        get() = javaResource.sourceEntityTypeName().applyValue({ args0 -> args0 })

    /**
     * Type of target entity.
     */
    public val targetEntityType: Output<String>
        get() = javaResource.targetEntityType().applyValue({ args0 -> args0 })

    /**
     * Name of the target Entity Type.
     */
    public val targetEntityTypeName: Output<String>
        get() = javaResource.targetEntityTypeName().applyValue({ args0 -> args0 })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LinkMapper : ResourceMapper<Link> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.Link::class == javaResource::class

    override fun map(javaResource: Resource): Link = Link(
        javaResource as
            com.pulumi.azurenative.customerinsights.Link,
    )
}

/**
 * @see [Link].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Link].
 */
public suspend fun link(name: String, block: suspend LinkResourceBuilder.() -> Unit): Link {
    val builder = LinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Link].
 * @param name The _unique_ name of the resulting resource.
 */
public fun link(name: String): Link {
    val builder = LinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
