@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.ProfileArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.EntityTypes
import com.pulumi.azurenative.customerinsights.kotlin.inputs.PropertyDefinitionArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.PropertyDefinitionArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.StrongIdArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.StrongIdArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The profile resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Profiles_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.CustomerInsights.Profile("profile", new()
 *     {
 *         ApiEntitySetName = "TestProfileType396",
 *         Fields = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "Id",
 *                 FieldType = "Edm.String",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "ProfileId",
 *                 FieldType = "Edm.String",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "LastName",
 *                 FieldType = "Edm.String",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "TestProfileType396",
 *                 FieldType = "Edm.String",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *             new AzureNative.CustomerInsights.Inputs.PropertyDefinitionArgs
 *             {
 *                 FieldName = "SavingAccountBalance",
 *                 FieldType = "Edm.Int32",
 *                 IsArray = false,
 *                 IsRequired = true,
 *             },
 *         },
 *         HubName = "sdkTestHub",
 *         LargeImage = "\\\\Images\\\\LargeImage",
 *         MediumImage = "\\\\Images\\\\MediumImage",
 *         ProfileName = "TestProfileType396",
 *         ResourceGroupName = "TestHubRG",
 *         SchemaItemTypeLink = "SchemaItemTypeLink",
 *         SmallImage = "\\\\Images\\\\smallImage",
 *         StrongIds = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.StrongIdArgs
 *             {
 *                 KeyPropertyNames = new[]
 *                 {
 *                     "Id",
 *                     "SavingAccountBalance",
 *                 },
 *                 StrongIdName = "Id",
 *             },
 *             new AzureNative.CustomerInsights.Inputs.StrongIdArgs
 *             {
 *                 KeyPropertyNames = new[]
 *                 {
 *                     "ProfileId",
 *                     "LastName",
 *                 },
 *                 StrongIdName = "ProfileId",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewProfile(ctx, "profile", &customerinsights.ProfileArgs{
 * 			ApiEntitySetName: pulumi.String("TestProfileType396"),
 * 			Fields: []customerinsights.PropertyDefinitionArgs{
 * 				{
 * 					FieldName:  pulumi.String("Id"),
 * 					FieldType:  pulumi.String("Edm.String"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 				{
 * 					FieldName:  pulumi.String("ProfileId"),
 * 					FieldType:  pulumi.String("Edm.String"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 				{
 * 					FieldName:  pulumi.String("LastName"),
 * 					FieldType:  pulumi.String("Edm.String"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 				{
 * 					FieldName:  pulumi.String("TestProfileType396"),
 * 					FieldType:  pulumi.String("Edm.String"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 				{
 * 					FieldName:  pulumi.String("SavingAccountBalance"),
 * 					FieldType:  pulumi.String("Edm.Int32"),
 * 					IsArray:    pulumi.Bool(false),
 * 					IsRequired: pulumi.Bool(true),
 * 				},
 * 			},
 * 			HubName:            pulumi.String("sdkTestHub"),
 * 			LargeImage:         pulumi.String("\\\\Images\\\\LargeImage"),
 * 			MediumImage:        pulumi.String("\\\\Images\\\\MediumImage"),
 * 			ProfileName:        pulumi.String("TestProfileType396"),
 * 			ResourceGroupName:  pulumi.String("TestHubRG"),
 * 			SchemaItemTypeLink: pulumi.String("SchemaItemTypeLink"),
 * 			SmallImage:         pulumi.String("\\\\Images\\\\smallImage"),
 * 			StrongIds: []customerinsights.StrongIdArgs{
 * 				{
 * 					KeyPropertyNames: pulumi.StringArray{
 * 						pulumi.String("Id"),
 * 						pulumi.String("SavingAccountBalance"),
 * 					},
 * 					StrongIdName: pulumi.String("Id"),
 * 				},
 * 				{
 * 					KeyPropertyNames: pulumi.StringArray{
 * 						pulumi.String("ProfileId"),
 * 						pulumi.String("LastName"),
 * 					},
 * 					StrongIdName: pulumi.String("ProfileId"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Profile;
 * import com.pulumi.azurenative.customerinsights.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .apiEntitySetName("TestProfileType396")
 *             .fields(
 *                 Map.ofEntries(
 *                     Map.entry("fieldName", "Id"),
 *                     Map.entry("fieldType", "Edm.String"),
 *                     Map.entry("isArray", false),
 *                     Map.entry("isRequired", true)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("fieldName", "ProfileId"),
 *                     Map.entry("fieldType", "Edm.String"),
 *                     Map.entry("isArray", false),
 *                     Map.entry("isRequired", true)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("fieldName", "LastName"),
 *                     Map.entry("fieldType", "Edm.String"),
 *                     Map.entry("isArray", false),
 *                     Map.entry("isRequired", true)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("fieldName", "TestProfileType396"),
 *                     Map.entry("fieldType", "Edm.String"),
 *                     Map.entry("isArray", false),
 *                     Map.entry("isRequired", true)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("fieldName", "SavingAccountBalance"),
 *                     Map.entry("fieldType", "Edm.Int32"),
 *                     Map.entry("isArray", false),
 *                     Map.entry("isRequired", true)
 *                 ))
 *             .hubName("sdkTestHub")
 *             .largeImage("\\\\Images\\\\LargeImage")
 *             .mediumImage("\\\\Images\\\\MediumImage")
 *             .profileName("TestProfileType396")
 *             .resourceGroupName("TestHubRG")
 *             .schemaItemTypeLink("SchemaItemTypeLink")
 *             .smallImage("\\\\Images\\\\smallImage")
 *             .strongIds(
 *                 Map.ofEntries(
 *                     Map.entry("keyPropertyNames",
 *                         "Id",
 *                         "SavingAccountBalance"),
 *                     Map.entry("strongIdName", "Id")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("keyPropertyNames",
 *                         "ProfileId",
 *                         "LastName"),
 *                     Map.entry("strongIdName", "ProfileId")
 *                 ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Profile azSdkTestHub/TestProfileType396 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles/{profileName}
 * ```
 * @property apiEntitySetName The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
 * @property attributes The attributes for the Type.
 * @property description Localized descriptions for the property.
 * @property displayName Localized display names for the property.
 * @property entityType Type of entity.
 * @property fields The properties of the Profile.
 * @property hubName The name of the hub.
 * @property instancesCount The instance count.
 * @property largeImage Large Image associated with the Property or EntityType.
 * @property localizedAttributes Any custom localized attributes for the Type.
 * @property mediumImage Medium Image associated with the Property or EntityType.
 * @property profileName The name of the profile.
 * @property resourceGroupName The name of the resource group.
 * @property schemaItemTypeLink The schema org link. This helps ACI identify and suggest semantic models.
 * @property smallImage Small Image associated with the Property or EntityType.
 * @property strongIds The strong IDs.
 * @property timestampFieldName The timestamp property name. Represents the time when the interaction or profile update happened.
 * @property typeName The name of the entity.
 */
public data class ProfileArgs(
    public val apiEntitySetName: Output<String>? = null,
    public val attributes: Output<Map<String, List<String>>>? = null,
    public val description: Output<Map<String, String>>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val entityType: Output<EntityTypes>? = null,
    public val fields: Output<List<PropertyDefinitionArgs>>? = null,
    public val hubName: Output<String>? = null,
    public val instancesCount: Output<Int>? = null,
    public val largeImage: Output<String>? = null,
    public val localizedAttributes: Output<Map<String, Map<String, String>>>? = null,
    public val mediumImage: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaItemTypeLink: Output<String>? = null,
    public val smallImage: Output<String>? = null,
    public val strongIds: Output<List<StrongIdArgs>>? = null,
    public val timestampFieldName: Output<String>? = null,
    public val typeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.ProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.ProfileArgs =
        com.pulumi.azurenative.customerinsights.ProfileArgs.builder()
            .apiEntitySetName(apiEntitySetName?.applyValue({ args0 -> args0 }))
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.map({ args0 -> args0 }))
                    }).toMap()
                }),
            )
            .description(
                description?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .entityType(entityType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fields(fields?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .instancesCount(instancesCount?.applyValue({ args0 -> args0 }))
            .largeImage(largeImage?.applyValue({ args0 -> args0 }))
            .localizedAttributes(
                localizedAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.map({ args0 -> args0.key.to(args0.value) }).toMap())
                    }).toMap()
                }),
            )
            .mediumImage(mediumImage?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaItemTypeLink(schemaItemTypeLink?.applyValue({ args0 -> args0 }))
            .smallImage(smallImage?.applyValue({ args0 -> args0 }))
            .strongIds(
                strongIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timestampFieldName(timestampFieldName?.applyValue({ args0 -> args0 }))
            .typeName(typeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProfileArgs].
 */
@PulumiTagMarker
public class ProfileArgsBuilder internal constructor() {
    private var apiEntitySetName: Output<String>? = null

    private var attributes: Output<Map<String, List<String>>>? = null

    private var description: Output<Map<String, String>>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var entityType: Output<EntityTypes>? = null

    private var fields: Output<List<PropertyDefinitionArgs>>? = null

    private var hubName: Output<String>? = null

    private var instancesCount: Output<Int>? = null

    private var largeImage: Output<String>? = null

    private var localizedAttributes: Output<Map<String, Map<String, String>>>? = null

    private var mediumImage: Output<String>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaItemTypeLink: Output<String>? = null

    private var smallImage: Output<String>? = null

    private var strongIds: Output<List<StrongIdArgs>>? = null

    private var timestampFieldName: Output<String>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
     */
    @JvmName("uhboodtbihqoaltc")
    public suspend fun apiEntitySetName(`value`: Output<String>) {
        this.apiEntitySetName = value
    }

    /**
     * @param value The attributes for the Type.
     */
    @JvmName("wivmghqaqhciewfm")
    public suspend fun attributes(`value`: Output<Map<String, List<String>>>) {
        this.attributes = value
    }

    /**
     * @param value Localized descriptions for the property.
     */
    @JvmName("almisnomchlhuryh")
    public suspend fun description(`value`: Output<Map<String, String>>) {
        this.description = value
    }

    /**
     * @param value Localized display names for the property.
     */
    @JvmName("udnhcfygjovghgps")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value Type of entity.
     */
    @JvmName("tbobmixhjjdoqgul")
    public suspend fun entityType(`value`: Output<EntityTypes>) {
        this.entityType = value
    }

    /**
     * @param value The properties of the Profile.
     */
    @JvmName("corcmycyfrfeysjt")
    public suspend fun fields(`value`: Output<List<PropertyDefinitionArgs>>) {
        this.fields = value
    }

    @JvmName("vahlaanjjxmtqshr")
    public suspend fun fields(vararg values: Output<PropertyDefinitionArgs>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values The properties of the Profile.
     */
    @JvmName("hnjhsuueqnvnjavk")
    public suspend fun fields(values: List<Output<PropertyDefinitionArgs>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("wtohqnnmlslvlqrw")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value The instance count.
     */
    @JvmName("paxuymvcpqanjdfx")
    public suspend fun instancesCount(`value`: Output<Int>) {
        this.instancesCount = value
    }

    /**
     * @param value Large Image associated with the Property or EntityType.
     */
    @JvmName("wopmjxmkxbqraepf")
    public suspend fun largeImage(`value`: Output<String>) {
        this.largeImage = value
    }

    /**
     * @param value Any custom localized attributes for the Type.
     */
    @JvmName("mbupeyvruhboqgtp")
    public suspend fun localizedAttributes(`value`: Output<Map<String, Map<String, String>>>) {
        this.localizedAttributes = value
    }

    /**
     * @param value Medium Image associated with the Property or EntityType.
     */
    @JvmName("uegjnbxcbjtqhuul")
    public suspend fun mediumImage(`value`: Output<String>) {
        this.mediumImage = value
    }

    /**
     * @param value The name of the profile.
     */
    @JvmName("vfcnnvtwhphombjq")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bpelbmubiohcbcqk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The schema org link. This helps ACI identify and suggest semantic models.
     */
    @JvmName("pnswwuiqhyncimyv")
    public suspend fun schemaItemTypeLink(`value`: Output<String>) {
        this.schemaItemTypeLink = value
    }

    /**
     * @param value Small Image associated with the Property or EntityType.
     */
    @JvmName("keehnrcgsreshuoo")
    public suspend fun smallImage(`value`: Output<String>) {
        this.smallImage = value
    }

    /**
     * @param value The strong IDs.
     */
    @JvmName("aeqemoqmshhklrsc")
    public suspend fun strongIds(`value`: Output<List<StrongIdArgs>>) {
        this.strongIds = value
    }

    @JvmName("fassbnhsdaqnpnlt")
    public suspend fun strongIds(vararg values: Output<StrongIdArgs>) {
        this.strongIds = Output.all(values.asList())
    }

    /**
     * @param values The strong IDs.
     */
    @JvmName("cjraikxxryqfoqnk")
    public suspend fun strongIds(values: List<Output<StrongIdArgs>>) {
        this.strongIds = Output.all(values)
    }

    /**
     * @param value The timestamp property name. Represents the time when the interaction or profile update happened.
     */
    @JvmName("fovqefpoootdxshp")
    public suspend fun timestampFieldName(`value`: Output<String>) {
        this.timestampFieldName = value
    }

    /**
     * @param value The name of the entity.
     */
    @JvmName("wxdlghxyxoahndgs")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
     */
    @JvmName("mfaidfliknkdybgr")
    public suspend fun apiEntitySetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiEntitySetName = mapped
    }

    /**
     * @param value The attributes for the Type.
     */
    @JvmName("htbjlwhcmfmugqxf")
    public suspend fun attributes(`value`: Map<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values The attributes for the Type.
     */
    @JvmName("jqhallmxgnkwwgsf")
    public fun attributes(vararg values: Pair<String, List<String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value Localized descriptions for the property.
     */
    @JvmName("pcxxfpvcvnigkmbr")
    public suspend fun description(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param values Localized descriptions for the property.
     */
    @JvmName("kfipdipujmgmisim")
    public fun description(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Localized display names for the property.
     */
    @JvmName("qkuvpahqlswgievw")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Localized display names for the property.
     */
    @JvmName("mjkkodhpaptcoprw")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Type of entity.
     */
    @JvmName("gjwbeurojlrksrnl")
    public suspend fun entityType(`value`: EntityTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityType = mapped
    }

    /**
     * @param value The properties of the Profile.
     */
    @JvmName("sfqsxctylqowlixe")
    public suspend fun fields(`value`: List<PropertyDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param argument The properties of the Profile.
     */
    @JvmName("etlveraoarfumulh")
    public suspend fun fields(argument: List<suspend PropertyDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PropertyDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param argument The properties of the Profile.
     */
    @JvmName("qhavqklpvskmcemx")
    public suspend fun fields(vararg argument: suspend PropertyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PropertyDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param argument The properties of the Profile.
     */
    @JvmName("dflaqpxmfducvrjb")
    public suspend fun fields(argument: suspend PropertyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PropertyDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param values The properties of the Profile.
     */
    @JvmName("tosqlqfigbhmhibj")
    public suspend fun fields(vararg values: PropertyDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("clqsmlufdhcaqgwe")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value The instance count.
     */
    @JvmName("xkeqsjshdkhnjxmk")
    public suspend fun instancesCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancesCount = mapped
    }

    /**
     * @param value Large Image associated with the Property or EntityType.
     */
    @JvmName("xabhdpmgrckwkunf")
    public suspend fun largeImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.largeImage = mapped
    }

    /**
     * @param value Any custom localized attributes for the Type.
     */
    @JvmName("bctbduckxfjvhiox")
    public suspend fun localizedAttributes(`value`: Map<String, Map<String, String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localizedAttributes = mapped
    }

    /**
     * @param values Any custom localized attributes for the Type.
     */
    @JvmName("yojncbnopxtgeevq")
    public fun localizedAttributes(vararg values: Pair<String, Map<String, String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localizedAttributes = mapped
    }

    /**
     * @param value Medium Image associated with the Property or EntityType.
     */
    @JvmName("dtcfqndmodgrtjyg")
    public suspend fun mediumImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediumImage = mapped
    }

    /**
     * @param value The name of the profile.
     */
    @JvmName("ckerrcpepxyfbgvo")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("oeleaeudxlebnkay")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The schema org link. This helps ACI identify and suggest semantic models.
     */
    @JvmName("ojdjxcvqcyxcrdfc")
    public suspend fun schemaItemTypeLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaItemTypeLink = mapped
    }

    /**
     * @param value Small Image associated with the Property or EntityType.
     */
    @JvmName("uxoliepfxfgvlmmm")
    public suspend fun smallImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smallImage = mapped
    }

    /**
     * @param value The strong IDs.
     */
    @JvmName("eyovwmchqiawcgfd")
    public suspend fun strongIds(`value`: List<StrongIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strongIds = mapped
    }

    /**
     * @param argument The strong IDs.
     */
    @JvmName("mhtkitilolmjriqe")
    public suspend fun strongIds(argument: List<suspend StrongIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { StrongIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.strongIds = mapped
    }

    /**
     * @param argument The strong IDs.
     */
    @JvmName("vfdcasealoxtbctl")
    public suspend fun strongIds(vararg argument: suspend StrongIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { StrongIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.strongIds = mapped
    }

    /**
     * @param argument The strong IDs.
     */
    @JvmName("xitwqoytawprdver")
    public suspend fun strongIds(argument: suspend StrongIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StrongIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.strongIds = mapped
    }

    /**
     * @param values The strong IDs.
     */
    @JvmName("diywphltorxyxwlx")
    public suspend fun strongIds(vararg values: StrongIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strongIds = mapped
    }

    /**
     * @param value The timestamp property name. Represents the time when the interaction or profile update happened.
     */
    @JvmName("vapciawryxiksspc")
    public suspend fun timestampFieldName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampFieldName = mapped
    }

    /**
     * @param value The name of the entity.
     */
    @JvmName("cqweqkfahsdlivag")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): ProfileArgs = ProfileArgs(
        apiEntitySetName = apiEntitySetName,
        attributes = attributes,
        description = description,
        displayName = displayName,
        entityType = entityType,
        fields = fields,
        hubName = hubName,
        instancesCount = instancesCount,
        largeImage = largeImage,
        localizedAttributes = localizedAttributes,
        mediumImage = mediumImage,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        schemaItemTypeLink = schemaItemTypeLink,
        smallImage = smallImage,
        strongIds = strongIds,
        timestampFieldName = timestampFieldName,
        typeName = typeName,
    )
}
