@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.RoleAssignmentArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.RoleTypes
import com.pulumi.azurenative.customerinsights.kotlin.inputs.AssignmentPrincipalArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.AssignmentPrincipalArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.ResourceSetDescriptionArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.ResourceSetDescriptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Role Assignment resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### RoleAssignments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignment = new AzureNative.CustomerInsights.RoleAssignment("roleAssignment", new()
 *     {
 *         AssignmentName = "assignmentName8976",
 *         HubName = "sdkTestHub",
 *         Principals = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.AssignmentPrincipalArgs
 *             {
 *                 PrincipalId = "4c54c38ffa9b416ba5a6d6c8a20cbe7e",
 *                 PrincipalType = "User",
 *             },
 *             new AzureNative.CustomerInsights.Inputs.AssignmentPrincipalArgs
 *             {
 *                 PrincipalId = "93061d15a5054f2b9948ae25724cf9d5",
 *                 PrincipalType = "User",
 *             },
 *         },
 *         ResourceGroupName = "TestHubRG",
 *         Role = AzureNative.CustomerInsights.RoleTypes.Admin,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewRoleAssignment(ctx, "roleAssignment", &customerinsights.RoleAssignmentArgs{
 * 			AssignmentName: pulumi.String("assignmentName8976"),
 * 			HubName:        pulumi.String("sdkTestHub"),
 * 			Principals: []customerinsights.AssignmentPrincipalArgs{
 * 				{
 * 					PrincipalId:   pulumi.String("4c54c38ffa9b416ba5a6d6c8a20cbe7e"),
 * 					PrincipalType: pulumi.String("User"),
 * 				},
 * 				{
 * 					PrincipalId:   pulumi.String("93061d15a5054f2b9948ae25724cf9d5"),
 * 					PrincipalType: pulumi.String("User"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 			Role:              customerinsights.RoleTypesAdmin,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.RoleAssignment;
 * import com.pulumi.azurenative.customerinsights.RoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignment = new RoleAssignment("roleAssignment", RoleAssignmentArgs.builder()
 *             .assignmentName("assignmentName8976")
 *             .hubName("sdkTestHub")
 *             .principals(
 *                 Map.ofEntries(
 *                     Map.entry("principalId", "4c54c38ffa9b416ba5a6d6c8a20cbe7e"),
 *                     Map.entry("principalType", "User")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("principalId", "93061d15a5054f2b9948ae25724cf9d5"),
 *                     Map.entry("principalType", "User")
 *                 ))
 *             .resourceGroupName("TestHubRG")
 *             .role("Admin")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:RoleAssignment azSdkTestHub/assignmentName8976 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roleAssignments/{assignmentName}
 * ```
 * @property assignmentName The assignment name
 * @property conflationPolicies Widget types set for the assignment.
 * @property connectors Connectors set for the assignment.
 * @property description Localized description for the metadata.
 * @property displayName Localized display names for the metadata.
 * @property hubName The name of the hub.
 * @property interactions Interactions set for the assignment.
 * @property kpis Kpis set for the assignment.
 * @property links Links set for the assignment.
 * @property principals The principals being assigned to.
 * @property profiles Profiles set for the assignment.
 * @property relationshipLinks The Role assignments set for the relationship links.
 * @property relationships The Role assignments set for the relationships.
 * @property resourceGroupName The name of the resource group.
 * @property role Type of roles.
 * @property roleAssignments The Role assignments set for the assignment.
 * @property sasPolicies Sas Policies set for the assignment.
 * @property segments The Role assignments set for the assignment.
 * @property views Views set for the assignment.
 * @property widgetTypes Widget types set for the assignment.
 */
public data class RoleAssignmentArgs(
    public val assignmentName: Output<String>? = null,
    public val conflationPolicies: Output<ResourceSetDescriptionArgs>? = null,
    public val connectors: Output<ResourceSetDescriptionArgs>? = null,
    public val description: Output<Map<String, String>>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val hubName: Output<String>? = null,
    public val interactions: Output<ResourceSetDescriptionArgs>? = null,
    public val kpis: Output<ResourceSetDescriptionArgs>? = null,
    public val links: Output<ResourceSetDescriptionArgs>? = null,
    public val principals: Output<List<AssignmentPrincipalArgs>>? = null,
    public val profiles: Output<ResourceSetDescriptionArgs>? = null,
    public val relationshipLinks: Output<ResourceSetDescriptionArgs>? = null,
    public val relationships: Output<ResourceSetDescriptionArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val role: Output<RoleTypes>? = null,
    public val roleAssignments: Output<ResourceSetDescriptionArgs>? = null,
    public val sasPolicies: Output<ResourceSetDescriptionArgs>? = null,
    public val segments: Output<ResourceSetDescriptionArgs>? = null,
    public val views: Output<ResourceSetDescriptionArgs>? = null,
    public val widgetTypes: Output<ResourceSetDescriptionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.RoleAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.RoleAssignmentArgs =
        com.pulumi.azurenative.customerinsights.RoleAssignmentArgs.builder()
            .assignmentName(assignmentName?.applyValue({ args0 -> args0 }))
            .conflationPolicies(
                conflationPolicies?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .connectors(connectors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(
                description?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .interactions(interactions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kpis(kpis?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .links(links?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .principals(
                principals?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .profiles(profiles?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .relationshipLinks(relationshipLinks?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .relationships(relationships?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleAssignments(roleAssignments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasPolicies(sasPolicies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .segments(segments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .views(views?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .widgetTypes(widgetTypes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RoleAssignmentArgs].
 */
@PulumiTagMarker
public class RoleAssignmentArgsBuilder internal constructor() {
    private var assignmentName: Output<String>? = null

    private var conflationPolicies: Output<ResourceSetDescriptionArgs>? = null

    private var connectors: Output<ResourceSetDescriptionArgs>? = null

    private var description: Output<Map<String, String>>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var hubName: Output<String>? = null

    private var interactions: Output<ResourceSetDescriptionArgs>? = null

    private var kpis: Output<ResourceSetDescriptionArgs>? = null

    private var links: Output<ResourceSetDescriptionArgs>? = null

    private var principals: Output<List<AssignmentPrincipalArgs>>? = null

    private var profiles: Output<ResourceSetDescriptionArgs>? = null

    private var relationshipLinks: Output<ResourceSetDescriptionArgs>? = null

    private var relationships: Output<ResourceSetDescriptionArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var role: Output<RoleTypes>? = null

    private var roleAssignments: Output<ResourceSetDescriptionArgs>? = null

    private var sasPolicies: Output<ResourceSetDescriptionArgs>? = null

    private var segments: Output<ResourceSetDescriptionArgs>? = null

    private var views: Output<ResourceSetDescriptionArgs>? = null

    private var widgetTypes: Output<ResourceSetDescriptionArgs>? = null

    /**
     * @param value The assignment name
     */
    @JvmName("jhfhedxykefldyqm")
    public suspend fun assignmentName(`value`: Output<String>) {
        this.assignmentName = value
    }

    /**
     * @param value Widget types set for the assignment.
     */
    @JvmName("jcucoyaydjclcxig")
    public suspend fun conflationPolicies(`value`: Output<ResourceSetDescriptionArgs>) {
        this.conflationPolicies = value
    }

    /**
     * @param value Connectors set for the assignment.
     */
    @JvmName("lhlgbtoapeiugimf")
    public suspend fun connectors(`value`: Output<ResourceSetDescriptionArgs>) {
        this.connectors = value
    }

    /**
     * @param value Localized description for the metadata.
     */
    @JvmName("wptyndebmnknigpc")
    public suspend fun description(`value`: Output<Map<String, String>>) {
        this.description = value
    }

    /**
     * @param value Localized display names for the metadata.
     */
    @JvmName("hajyroolxarpqapx")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("ahpogwqfktqsnavj")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value Interactions set for the assignment.
     */
    @JvmName("wpdytuoioudrqpqr")
    public suspend fun interactions(`value`: Output<ResourceSetDescriptionArgs>) {
        this.interactions = value
    }

    /**
     * @param value Kpis set for the assignment.
     */
    @JvmName("thrdcmomsrkulwnr")
    public suspend fun kpis(`value`: Output<ResourceSetDescriptionArgs>) {
        this.kpis = value
    }

    /**
     * @param value Links set for the assignment.
     */
    @JvmName("xiybtuhpcggvwmad")
    public suspend fun links(`value`: Output<ResourceSetDescriptionArgs>) {
        this.links = value
    }

    /**
     * @param value The principals being assigned to.
     */
    @JvmName("erhwpicnwopsfins")
    public suspend fun principals(`value`: Output<List<AssignmentPrincipalArgs>>) {
        this.principals = value
    }

    @JvmName("luihwuthghaflsfj")
    public suspend fun principals(vararg values: Output<AssignmentPrincipalArgs>) {
        this.principals = Output.all(values.asList())
    }

    /**
     * @param values The principals being assigned to.
     */
    @JvmName("fkxhrludprktdouv")
    public suspend fun principals(values: List<Output<AssignmentPrincipalArgs>>) {
        this.principals = Output.all(values)
    }

    /**
     * @param value Profiles set for the assignment.
     */
    @JvmName("fryccwmpvqmxulwq")
    public suspend fun profiles(`value`: Output<ResourceSetDescriptionArgs>) {
        this.profiles = value
    }

    /**
     * @param value The Role assignments set for the relationship links.
     */
    @JvmName("dcbfkohojawiflle")
    public suspend fun relationshipLinks(`value`: Output<ResourceSetDescriptionArgs>) {
        this.relationshipLinks = value
    }

    /**
     * @param value The Role assignments set for the relationships.
     */
    @JvmName("urmnvahwrjsammup")
    public suspend fun relationships(`value`: Output<ResourceSetDescriptionArgs>) {
        this.relationships = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jakvtalcpwbuumui")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Type of roles.
     */
    @JvmName("bqsncgqwhpftgllg")
    public suspend fun role(`value`: Output<RoleTypes>) {
        this.role = value
    }

    /**
     * @param value The Role assignments set for the assignment.
     */
    @JvmName("yyhovyvvdqoqpmbk")
    public suspend fun roleAssignments(`value`: Output<ResourceSetDescriptionArgs>) {
        this.roleAssignments = value
    }

    /**
     * @param value Sas Policies set for the assignment.
     */
    @JvmName("eiyllorsynohuerd")
    public suspend fun sasPolicies(`value`: Output<ResourceSetDescriptionArgs>) {
        this.sasPolicies = value
    }

    /**
     * @param value The Role assignments set for the assignment.
     */
    @JvmName("bvfdoiaxjlpjwelu")
    public suspend fun segments(`value`: Output<ResourceSetDescriptionArgs>) {
        this.segments = value
    }

    /**
     * @param value Views set for the assignment.
     */
    @JvmName("neakqruonfdsyvch")
    public suspend fun views(`value`: Output<ResourceSetDescriptionArgs>) {
        this.views = value
    }

    /**
     * @param value Widget types set for the assignment.
     */
    @JvmName("hkaoybgvcdpcwslc")
    public suspend fun widgetTypes(`value`: Output<ResourceSetDescriptionArgs>) {
        this.widgetTypes = value
    }

    /**
     * @param value The assignment name
     */
    @JvmName("fsbwbcswpcpaghlk")
    public suspend fun assignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentName = mapped
    }

    /**
     * @param value Widget types set for the assignment.
     */
    @JvmName("dijlitmhdmxrqlgc")
    public suspend fun conflationPolicies(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflationPolicies = mapped
    }

    /**
     * @param argument Widget types set for the assignment.
     */
    @JvmName("egwtqglrelqfxokt")
    public suspend
    fun conflationPolicies(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.conflationPolicies = mapped
    }

    /**
     * @param value Connectors set for the assignment.
     */
    @JvmName("gxgnorjisturdhix")
    public suspend fun connectors(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectors = mapped
    }

    /**
     * @param argument Connectors set for the assignment.
     */
    @JvmName("dascmujcgvpamrwi")
    public suspend fun connectors(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectors = mapped
    }

    /**
     * @param value Localized description for the metadata.
     */
    @JvmName("iyxxwbhlrmntaola")
    public suspend fun description(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param values Localized description for the metadata.
     */
    @JvmName("butjlqnnwyhevlfv")
    public fun description(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Localized display names for the metadata.
     */
    @JvmName("jilglwaalrvdvtau")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Localized display names for the metadata.
     */
    @JvmName("qiifdqkixjwprhsl")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("xckywumtradkihui")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value Interactions set for the assignment.
     */
    @JvmName("xsmdmlhjhybagqog")
    public suspend fun interactions(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interactions = mapped
    }

    /**
     * @param argument Interactions set for the assignment.
     */
    @JvmName("reacupamtfbovssc")
    public suspend fun interactions(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.interactions = mapped
    }

    /**
     * @param value Kpis set for the assignment.
     */
    @JvmName("lbvmmvshjcjjlgmk")
    public suspend fun kpis(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kpis = mapped
    }

    /**
     * @param argument Kpis set for the assignment.
     */
    @JvmName("swvhepfktewbjrcn")
    public suspend fun kpis(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kpis = mapped
    }

    /**
     * @param value Links set for the assignment.
     */
    @JvmName("mfgapriwfdkhtnac")
    public suspend fun links(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param argument Links set for the assignment.
     */
    @JvmName("lquopmobiitrreqk")
    public suspend fun links(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param value The principals being assigned to.
     */
    @JvmName("wjncajpuakhowvlt")
    public suspend fun principals(`value`: List<AssignmentPrincipalArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principals = mapped
    }

    /**
     * @param argument The principals being assigned to.
     */
    @JvmName("kgtgdjrosmmglqeg")
    public suspend fun principals(argument: List<suspend AssignmentPrincipalArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssignmentPrincipalArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.principals = mapped
    }

    /**
     * @param argument The principals being assigned to.
     */
    @JvmName("kvjuoahacoujhmyg")
    public suspend fun principals(
        vararg
        argument: suspend AssignmentPrincipalArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AssignmentPrincipalArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.principals = mapped
    }

    /**
     * @param argument The principals being assigned to.
     */
    @JvmName("mqmxgntkdfyxggav")
    public suspend fun principals(argument: suspend AssignmentPrincipalArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AssignmentPrincipalArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.principals = mapped
    }

    /**
     * @param values The principals being assigned to.
     */
    @JvmName("cbsykpcghlkhwnvu")
    public suspend fun principals(vararg values: AssignmentPrincipalArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principals = mapped
    }

    /**
     * @param value Profiles set for the assignment.
     */
    @JvmName("wvlsdxrbfraksvyt")
    public suspend fun profiles(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profiles = mapped
    }

    /**
     * @param argument Profiles set for the assignment.
     */
    @JvmName("fljqpsombqqiwtbj")
    public suspend fun profiles(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.profiles = mapped
    }

    /**
     * @param value The Role assignments set for the relationship links.
     */
    @JvmName("ulacxlmjkywerwhb")
    public suspend fun relationshipLinks(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationshipLinks = mapped
    }

    /**
     * @param argument The Role assignments set for the relationship links.
     */
    @JvmName("rauwggskgdhpanca")
    public suspend
    fun relationshipLinks(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.relationshipLinks = mapped
    }

    /**
     * @param value The Role assignments set for the relationships.
     */
    @JvmName("sgurlwoxfdhwxohv")
    public suspend fun relationships(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationships = mapped
    }

    /**
     * @param argument The Role assignments set for the relationships.
     */
    @JvmName("yjbthcfweogtwkjv")
    public suspend fun relationships(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.relationships = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("puvvsfkearomrbjr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Type of roles.
     */
    @JvmName("tuolcroodkoxsljx")
    public suspend fun role(`value`: RoleTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The Role assignments set for the assignment.
     */
    @JvmName("kbrmaywdwkamdorw")
    public suspend fun roleAssignments(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleAssignments = mapped
    }

    /**
     * @param argument The Role assignments set for the assignment.
     */
    @JvmName("lawoedxqakamyhid")
    public suspend
    fun roleAssignments(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.roleAssignments = mapped
    }

    /**
     * @param value Sas Policies set for the assignment.
     */
    @JvmName("brrvcfgedsfkbmhc")
    public suspend fun sasPolicies(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasPolicies = mapped
    }

    /**
     * @param argument Sas Policies set for the assignment.
     */
    @JvmName("qysirfybpkoqqrfn")
    public suspend fun sasPolicies(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasPolicies = mapped
    }

    /**
     * @param value The Role assignments set for the assignment.
     */
    @JvmName("yqmlwkyhivldivgy")
    public suspend fun segments(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segments = mapped
    }

    /**
     * @param argument The Role assignments set for the assignment.
     */
    @JvmName("wrbsxhoxtxjqppuk")
    public suspend fun segments(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.segments = mapped
    }

    /**
     * @param value Views set for the assignment.
     */
    @JvmName("iswforhcymbrcyno")
    public suspend fun views(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.views = mapped
    }

    /**
     * @param argument Views set for the assignment.
     */
    @JvmName("vjisqajjhphtylxy")
    public suspend fun views(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.views = mapped
    }

    /**
     * @param value Widget types set for the assignment.
     */
    @JvmName("ckfyvqhveoipfoss")
    public suspend fun widgetTypes(`value`: ResourceSetDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.widgetTypes = mapped
    }

    /**
     * @param argument Widget types set for the assignment.
     */
    @JvmName("hglbwwvimlfbtfcy")
    public suspend fun widgetTypes(argument: suspend ResourceSetDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.widgetTypes = mapped
    }

    internal fun build(): RoleAssignmentArgs = RoleAssignmentArgs(
        assignmentName = assignmentName,
        conflationPolicies = conflationPolicies,
        connectors = connectors,
        description = description,
        displayName = displayName,
        hubName = hubName,
        interactions = interactions,
        kpis = kpis,
        links = links,
        principals = principals,
        profiles = profiles,
        relationshipLinks = relationshipLinks,
        relationships = relationships,
        resourceGroupName = resourceGroupName,
        role = role,
        roleAssignments = roleAssignments,
        sasPolicies = sasPolicies,
        segments = segments,
        views = views,
        widgetTypes = widgetTypes,
    )
}
