@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingStructureArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connector mapping property structure.
 * @property columnName The column name of the import file.
 * @property customFormatSpecifier Custom format specifier for input parsing.
 * @property isEncrypted Indicates if the column is encrypted.
 * @property propertyName The property name of the mapping entity.
 */
public data class ConnectorMappingStructureArgs(
    public val columnName: Output<String>,
    public val customFormatSpecifier: Output<String>? = null,
    public val isEncrypted: Output<Boolean>? = null,
    public val propertyName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingStructureArgs> {
    override fun toJava():
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingStructureArgs =
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingStructureArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .customFormatSpecifier(customFormatSpecifier?.applyValue({ args0 -> args0 }))
            .isEncrypted(isEncrypted?.applyValue({ args0 -> args0 }))
            .propertyName(propertyName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorMappingStructureArgs].
 */
@PulumiTagMarker
public class ConnectorMappingStructureArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var customFormatSpecifier: Output<String>? = null

    private var isEncrypted: Output<Boolean>? = null

    private var propertyName: Output<String>? = null

    /**
     * @param value The column name of the import file.
     */
    @JvmName("useiwpofrngnhjwl")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value Custom format specifier for input parsing.
     */
    @JvmName("spqyanwasdkgnooi")
    public suspend fun customFormatSpecifier(`value`: Output<String>) {
        this.customFormatSpecifier = value
    }

    /**
     * @param value Indicates if the column is encrypted.
     */
    @JvmName("gfpyiymnenubrkus")
    public suspend fun isEncrypted(`value`: Output<Boolean>) {
        this.isEncrypted = value
    }

    /**
     * @param value The property name of the mapping entity.
     */
    @JvmName("kujgoexnddbpvhhu")
    public suspend fun propertyName(`value`: Output<String>) {
        this.propertyName = value
    }

    /**
     * @param value The column name of the import file.
     */
    @JvmName("qcqgjabglguivctm")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value Custom format specifier for input parsing.
     */
    @JvmName("enroiobtbvnurekc")
    public suspend fun customFormatSpecifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customFormatSpecifier = mapped
    }

    /**
     * @param value Indicates if the column is encrypted.
     */
    @JvmName("gnskcwfirvshubsy")
    public suspend fun isEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEncrypted = mapped
    }

    /**
     * @param value The property name of the mapping entity.
     */
    @JvmName("pxxkvbstgnkwhkpx")
    public suspend fun propertyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    internal fun build(): ConnectorMappingStructureArgs = ConnectorMappingStructureArgs(
        columnName = columnName ?: throw PulumiNullFieldException("columnName"),
        customFormatSpecifier = customFormatSpecifier,
        isEncrypted = isEncrypted,
        propertyName = propertyName ?: throw PulumiNullFieldException("propertyName"),
    )
}
