@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetImageUploadUrlForEntityTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entityType Type of entity. Can be Profile or Interaction.
 * @property entityTypeName Name of the entity type.
 * @property hubName The name of the hub.
 * @property relativePath Relative path of the image.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetImageUploadUrlForEntityTypePlainArgs(
    public val entityType: String? = null,
    public val entityTypeName: String? = null,
    public val hubName: String,
    public val relativePath: String? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetImageUploadUrlForEntityTypePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.customerinsights.inputs.GetImageUploadUrlForEntityTypePlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetImageUploadUrlForEntityTypePlainArgs.builder()
            .entityType(entityType?.let({ args0 -> args0 }))
            .entityTypeName(entityTypeName?.let({ args0 -> args0 }))
            .hubName(hubName.let({ args0 -> args0 }))
            .relativePath(relativePath?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImageUploadUrlForEntityTypePlainArgs].
 */
@PulumiTagMarker
public class GetImageUploadUrlForEntityTypePlainArgsBuilder internal constructor() {
    private var entityType: String? = null

    private var entityTypeName: String? = null

    private var hubName: String? = null

    private var relativePath: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Type of entity. Can be Profile or Interaction.
     */
    @JvmName("tkcphtabqxmqrija")
    public suspend fun entityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.entityType = mapped
    }

    /**
     * @param value Name of the entity type.
     */
    @JvmName("obpslchklyfvdsoo")
    public suspend fun entityTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.entityTypeName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("hkpgcpqcbvtwofik")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value Relative path of the image.
     */
    @JvmName("bsvvblnptirobtnf")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.relativePath = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nfvscetbtxepwcna")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetImageUploadUrlForEntityTypePlainArgs =
        GetImageUploadUrlForEntityTypePlainArgs(
            entityType = entityType,
            entityTypeName = entityTypeName,
            hubName = hubName ?: throw PulumiNullFieldException("hubName"),
            relativePath = relativePath,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
