@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetKpiPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The name of the hub.
 * @property kpiName The name of the KPI.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetKpiPlainArgs(
    public val hubName: String,
    public val kpiName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetKpiPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetKpiPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetKpiPlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .kpiName(kpiName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKpiPlainArgs].
 */
@PulumiTagMarker
public class GetKpiPlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var kpiName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the hub.
     */
    @JvmName("lyoqrdevfednewrk")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the KPI.
     */
    @JvmName("wvpnqbpkggqpqdmd")
    public suspend fun kpiName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kpiName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uftgdnuqdxjfjogn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetKpiPlainArgs = GetKpiPlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        kpiName = kpiName ?: throw PulumiNullFieldException("kpiName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
