@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetRelationshipPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The name of the hub.
 * @property relationshipName The name of the relationship.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetRelationshipPlainArgs(
    public val hubName: String,
    public val relationshipName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetRelationshipPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetRelationshipPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetRelationshipPlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .relationshipName(relationshipName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRelationshipPlainArgs].
 */
@PulumiTagMarker
public class GetRelationshipPlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var relationshipName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the hub.
     */
    @JvmName("ebqnuysehtnbqvri")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the relationship.
     */
    @JvmName("nbsxpvdqyohjpaem")
    public suspend fun relationshipName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relationshipName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gqefhkccmlhqcink")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRelationshipPlainArgs = GetRelationshipPlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        relationshipName = relationshipName ?: throw PulumiNullFieldException("relationshipName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
