@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetViewPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The name of the hub.
 * @property resourceGroupName The name of the resource group.
 * @property userId The user ID. Use * to retrieve hub level view.
 * @property viewName The name of the view.
 */
public data class GetViewPlainArgs(
    public val hubName: String,
    public val resourceGroupName: String,
    public val userId: String,
    public val viewName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetViewPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetViewPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetViewPlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .userId(userId.let({ args0 -> args0 }))
            .viewName(viewName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetViewPlainArgs].
 */
@PulumiTagMarker
public class GetViewPlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var resourceGroupName: String? = null

    private var userId: String? = null

    private var viewName: String? = null

    /**
     * @param value The name of the hub.
     */
    @JvmName("inpwgwaehtxtkviv")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ovvhjvyyihtjymep")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The user ID. Use * to retrieve hub level view.
     */
    @JvmName("dfaubkmuwrjpinvq")
    public suspend fun userId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userId = mapped
    }

    /**
     * @param value The name of the view.
     */
    @JvmName("hbqmggroevhfilpk")
    public suspend fun viewName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.viewName = mapped
    }

    internal fun build(): GetViewPlainArgs = GetViewPlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        userId = userId ?: throw PulumiNullFieldException("userId"),
        viewName = viewName ?: throw PulumiNullFieldException("viewName"),
    )
}
