@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.TypePropertiesMappingArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.LinkTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Metadata for a Link's property mapping.
 * @property linkType Link type.
 * @property sourcePropertyName  Property name on the source Entity Type.
 * @property targetPropertyName Property name on the target Entity Type.
 */
public data class TypePropertiesMappingArgs(
    public val linkType: Output<LinkTypes>? = null,
    public val sourcePropertyName: Output<String>,
    public val targetPropertyName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.TypePropertiesMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.TypePropertiesMappingArgs =
        com.pulumi.azurenative.customerinsights.inputs.TypePropertiesMappingArgs.builder()
            .linkType(linkType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourcePropertyName(sourcePropertyName.applyValue({ args0 -> args0 }))
            .targetPropertyName(targetPropertyName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TypePropertiesMappingArgs].
 */
@PulumiTagMarker
public class TypePropertiesMappingArgsBuilder internal constructor() {
    private var linkType: Output<LinkTypes>? = null

    private var sourcePropertyName: Output<String>? = null

    private var targetPropertyName: Output<String>? = null

    /**
     * @param value Link type.
     */
    @JvmName("ipxexjrmtfmrirvb")
    public suspend fun linkType(`value`: Output<LinkTypes>) {
        this.linkType = value
    }

    /**
     * @param value  Property name on the source Entity Type.
     */
    @JvmName("mdhfxmlifdasnooj")
    public suspend fun sourcePropertyName(`value`: Output<String>) {
        this.sourcePropertyName = value
    }

    /**
     * @param value Property name on the target Entity Type.
     */
    @JvmName("lvlaukcoowpbigyw")
    public suspend fun targetPropertyName(`value`: Output<String>) {
        this.targetPropertyName = value
    }

    /**
     * @param value Link type.
     */
    @JvmName("ckmliaoiqxplnfsd")
    public suspend fun linkType(`value`: LinkTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkType = mapped
    }

    /**
     * @param value  Property name on the source Entity Type.
     */
    @JvmName("uluhpmlprcnmjeys")
    public suspend fun sourcePropertyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePropertyName = mapped
    }

    /**
     * @param value Property name on the target Entity Type.
     */
    @JvmName("ovrbobwxxxghvydq")
    public suspend fun targetPropertyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPropertyName = mapped
    }

    internal fun build(): TypePropertiesMappingArgs = TypePropertiesMappingArgs(
        linkType = linkType,
        sourcePropertyName = sourcePropertyName ?: throw PulumiNullFieldException("sourcePropertyName"),
        targetPropertyName = targetPropertyName ?: throw PulumiNullFieldException("targetPropertyName"),
    )
}
