@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Connector mapping property availability.
 * @property frequency The frequency to update.
 * @property interval The interval of the given frequency to use.
 */
public data class ConnectorMappingAvailabilityResponse(
    public val frequency: String? = null,
    public val interval: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ConnectorMappingAvailabilityResponse):
            ConnectorMappingAvailabilityResponse = ConnectorMappingAvailabilityResponse(
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval(),
        )
    }
}
