@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The KPI extract.
 * @property expression The expression.
 * @property extractName KPI extract name.
 */
public data class KpiExtractResponse(
    public val expression: String,
    public val extractName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.KpiExtractResponse):
            KpiExtractResponse = KpiExtractResponse(
            expression = javaType.expression(),
            extractName = javaType.extractName(),
        )
    }
}
