@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * The definition of a prediction distribution.
 * @property negatives Number of negatives.
 * @property negativesAboveThreshold Number of negatives above threshold.
 * @property positives Number of positives.
 * @property positivesAboveThreshold Number of positives above threshold.
 * @property scoreThreshold Score threshold.
 */
public data class PredictionDistributionDefinitionResponseDistributions(
    public val negatives: Double? = null,
    public val negativesAboveThreshold: Double? = null,
    public val positives: Double? = null,
    public val positivesAboveThreshold: Double? = null,
    public val scoreThreshold: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.PredictionDistributionDefinitionResponseDistributions):
            PredictionDistributionDefinitionResponseDistributions =
            PredictionDistributionDefinitionResponseDistributions(
                negatives = javaType.negatives().map({ args0 -> args0 }).orElse(null),
                negativesAboveThreshold = javaType.negativesAboveThreshold().map({ args0 -> args0 }).orElse(null),
                positives = javaType.positives().map({ args0 -> args0 }).orElse(null),
                positivesAboveThreshold = javaType.positivesAboveThreshold().map({ args0 -> args0 }).orElse(null),
                scoreThreshold = javaType.scoreThreshold().map({ args0 -> args0 }).orElse(null),
            )
    }
}
