@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the link mapping of prediction.
 * @property grade The grade of the link mapping.
 * @property reason The reason of the link mapping.
 * @property score The score of the link mapping.
 */
public data class PredictionResponseMappings(
    public val grade: String,
    public val reason: String,
    public val score: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.PredictionResponseMappings):
            PredictionResponseMappings = PredictionResponseMappings(
            grade = javaType.grade(),
            reason = javaType.reason(),
            score = javaType.score(),
        )
    }
}
